/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.prefab;

import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricPole;
import com.cout970.magneticraft.api.electricity.IInterPoleWire;
import com.cout970.magneticraft.api.electricity.prefab.InterPoleWire;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ElectricPoleTier1
implements IElectricPole {
    protected List<IInterPoleWire> connections = new ArrayList<IInterPoleWire>();
    private int connectionsBlocked;
    protected IElectricConductor cond;
    protected TileEntity parent;
    public boolean update = true;
    public int glList = -1;

    public ElectricPoleTier1(TileEntity tile, IElectricConductor cond) {
        this.parent = tile;
        this.cond = cond;
        this.connectionsBlocked = 1;
    }

    @Override
    public void disconnectAll() {
        this.update = true;
        ArrayList<IInterPoleWire> list = new ArrayList<IInterPoleWire>();
        list.addAll(this.connections);
        for (IInterPoleWire con : list) {
            if (con.getWorld() == null) {
                if (this.parent == null) continue;
                con.setWorld(this.parent.func_145831_w());
            }
            if (con.getStart() != null) {
                con.getStart().onDisconnect(con);
            }
            if (con.getEnd() == null) continue;
            con.getEnd().onDisconnect(con);
        }
    }

    @Override
    public void iterate() {
        if (this.update) {
            this.update = false;
            for (IInterPoleWire c2 : this.connections) {
                c2.setWorld(this.getParent().func_145831_w());
            }
            this.refreshList();
        }
        if (this.parent.func_145831_w().field_72995_K) {
            return;
        }
        this.connections.stream().filter(c -> c.getStart() == this).forEach(IInterPoleWire::iterate);
    }

    @Override
    public List<IInterPoleWire> getConnectedConductors() {
        return this.connections;
    }

    @Override
    public boolean canConnectWire(int tier, IElectricPole to, boolean isManual) {
        if (to == this) {
            return false;
        }
        if (tier != 0) {
            return false;
        }
        VecDouble vec = new VecDouble(this.getParent()).add(new VecDouble(to.getParent()).getOpposite());
        if (vec.mag() > 16.0) {
            return false;
        }
        for (IInterPoleWire i : this.connections) {
            if (!i.vecStart().equals(new VecInt(this.getParent())) || !i.vecEnd().equals(new VecInt(to.getParent()))) continue;
            return false;
        }
        if (isManual && this.connectionsBlocked >= 2) {
            return false;
        }
        if (!isManual && this.connectionsBlocked >= 1) {
            return false;
        }
        return this.connections.size() <= 6;
    }

    @Override
    public void onDisconnect(IInterPoleWire conn) {
        this.connections.remove(conn);
        this.refreshList();
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }

    @Override
    public IElectricConductor getConductor() {
        return this.cond;
    }

    @Override
    public VecDouble[] getWireConnectors() {
        switch (this.getParent().func_145832_p() - 6) {
            case 0: {
                return new VecDouble[]{new VecDouble(1.845, 0.75, 0.5), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.845, 0.75, 0.5)};
            }
            case 4: {
                return new VecDouble[]{new VecDouble(-0.845, 0.75, 0.5), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.845, 0.75, 0.5)};
            }
            case 1: {
                return new VecDouble[]{new VecDouble(1.45, 0.75, 1.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.45, 0.75, -0.45)};
            }
            case 5: {
                return new VecDouble[]{new VecDouble(-0.45, 0.75, -0.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.45, 0.75, 1.45)};
            }
            case 3: {
                return new VecDouble[]{new VecDouble(-0.45, 0.75, 1.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.45, 0.75, -0.45)};
            }
            case 7: {
                return new VecDouble[]{new VecDouble(1.45, 0.75, -0.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.45, 0.75, 1.45)};
            }
            case 2: {
                return new VecDouble[]{new VecDouble(0.5, 0.75, 1.845), new VecDouble(0.5, 1.0, 0.5), new VecDouble(0.5, 0.75, -0.845)};
            }
            case 6: {
                return new VecDouble[]{new VecDouble(0.5, 0.75, -0.845), new VecDouble(0.5, 1.0, 0.5), new VecDouble(0.5, 0.75, 1.845)};
            }
        }
        return new VecDouble[0];
    }

    @Override
    public void onConnect(IInterPoleWire wire) {
        this.connections.add(wire);
        this.update = true;
    }

    private void refreshList() {
        if (this.getParent().func_145831_w().field_72995_K && this.glList != -1) {
            GL11.glDeleteLists((int)this.glList, (int)1);
            this.glList = -1;
        }
    }

    public int getConnectionMode() {
        return this.connectionsBlocked;
    }

    public void blockAllConnections() {
        this.disconnectAll();
        this.connectionsBlocked = 2;
    }

    public void blockAutoConnections() {
        this.disconnectAll();
        this.connectionsBlocked = 1;
    }

    public void allowConnections() {
        ElectricPoleTier1.findConnections(this);
        this.connectionsBlocked = 0;
    }

    public void setConnectionMode(int mode) {
        this.disconnectAll();
        this.connectionsBlocked = mode;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagList nbtList = new NBTTagList();
        for (IInterPoleWire c : this.connections) {
            NBTTagCompound tag = new NBTTagCompound();
            c.save(tag);
            nbtList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("connect", (NBTBase)nbtList);
        nbt.func_74768_a("mode", this.connectionsBlocked);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.update = true;
        NBTTagList nbtList = nbt.func_150295_c("connect", 10);
        this.connections.clear();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            InterPoleWire p = new InterPoleWire();
            p.load(tag);
            this.connections.add(p);
        }
        this.connectionsBlocked = nbt.func_74762_e("mode");
    }

    public static void findConnections(IElectricPole pole) {
        pole.disconnectAll();
        int rad = 16;
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    TileEntity t;
                    IElectricPole p;
                    if (x == 0 && z == 0 || (p = ElectricUtils.getElectricPole(t = new VecInt(pole.getParent()).add(x, y, z).getTileEntity(pole.getParent().func_145831_w()))) == null || !p.canConnectWire(0, pole, false) || !pole.canConnectWire(0, p, false)) continue;
                    InterPoleWire wire = new InterPoleWire(new VecInt(pole.getParent()), new VecInt(p.getParent()));
                    wire.setWorld(p.getParent().func_145831_w());
                    pole.onConnect(wire);
                    p.onConnect(wire);
                }
            }
        }
    }
}

