/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.prefab;

import com.cout970.magneticraft.api.electricity.ElectricConstants;
import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IIndexedConnection;
import com.cout970.magneticraft.api.electricity.prefab.IndexedConnection;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ElectricConductor
implements IElectricConductor {
    protected List<IIndexedConnection> con = new ArrayList<IIndexedConnection>();
    protected boolean connected = false;
    protected TileEntity tile;
    protected double V;
    protected double I;
    protected double R;
    protected int tier;
    protected long lastTick;
    protected double Iabs;
    protected double Itot;
    protected double[] currents;
    public static final double Q1 = 0.1;
    public static final double Q2 = 20.0;

    public ElectricConductor(TileEntity tile, double resist) {
        this(tile, 0, resist);
    }

    public ElectricConductor(TileEntity tile, int tier, double resist) {
        this.tile = tile;
        this.R = resist;
        this.tier = tier;
    }

    public ElectricConductor(TileEntity tile) {
        this(tile, ElectricConstants.RESISTANCE_COPPER_LOW);
    }

    @Override
    public TileEntity getParent() {
        return this.tile;
    }

    @Override
    public double getVoltage() {
        long worldTime = this.getParent().func_145831_w().func_82737_E();
        if ((worldTime & 0xFFFFL) == this.lastTick) {
            return this.V;
        }
        this.lastTick = (int)(worldTime & 0xFFFFL);
        this.computeVoltage();
        return this.V;
    }

    @Override
    public void recache() {
        if (!this.connected) {
            this.connected = true;
            this.con.clear();
            int sides = 0;
            for (VecInt f : this.getValidConnections()) {
                TileEntity target = MgUtils.getTileEntity(this.tile, f);
                IElectricConductor[] c = ElectricUtils.getElectricCond(target, f.getOpposite(), this.getTier());
                IEnergyInterface inter = ElectricUtils.getInterface(target, f.getOpposite(), this.getTier());
                if (c != null) {
                    for (IElectricConductor e : c) {
                        if (e == this || !this.isAbleToConnect(e, f) || !e.isAbleToConnect(this, f.getOpposite()) || ElectricUtils.alreadyContains(e.getConnections(), f.getOpposite())) continue;
                        this.con.add(new IndexedConnection((IElectricConductor)this, f, e, sides));
                        ++sides;
                    }
                }
                if (inter == null || !inter.canConnect(f)) continue;
                this.con.add(new IndexedConnection((IElectricConductor)this, f, inter, sides));
                ++sides;
            }
            if (this.currents == null) {
                this.currents = new double[sides];
            } else if (this.currents.length != sides) {
                double[] temp = new double[sides];
                System.arraycopy(this.currents, 0, temp, 0, Math.min(sides, this.currents.length));
                this.currents = temp;
            }
        }
    }

    @Override
    public void iterate() {
        TileEntity tile = this.getParent();
        World w = tile.func_145831_w();
        if (w.field_72995_K) {
            return;
        }
        tile.func_70296_d();
        this.getVoltage();
        for (IIndexedConnection f : this.con) {
            ElectricConductor.valance(f, this.currents);
        }
    }

    public static void valance(IIndexedConnection f, double[] currents) {
        double watt;
        IElectricConductor cond = f.getConductor();
        IEnergyInterface c = f.getEnergyInterface();
        if (cond != null && cond.canFlowPower(f)) {
            double resistence = f.getSource().getResistance() + cond.getResistance();
            double deltaV = f.getSource().getVoltage() - cond.getVoltage();
            if (Double.isNaN(currents[f.getIndex()])) {
                currents[f.getIndex()] = 0.0;
            }
            double current = currents[f.getIndex()];
            double vDiff = deltaV - current * resistence;
            vDiff = Math.min(vDiff, Math.abs(deltaV));
            vDiff = Math.max(vDiff, -Math.abs(deltaV));
            int n = f.getIndex();
            currents[n] = currents[n] + vDiff * f.getSource().getIndScale() / f.getSource().getVoltageMultiplier();
            f.getSource().applyCurrent(-(current += deltaV * f.getSource().getCondParallel() / f.getSource().getVoltageMultiplier()));
            cond.applyCurrent(current);
        }
        if (c != null && f.getSource().getVoltage() > ElectricConstants.ENERGY_INTERFACE_LEVEL && c.canAcceptEnergy(f) && (watt = Math.min(c.getMaxFlow(), (f.getSource().getVoltage() - ElectricConstants.ENERGY_INTERFACE_LEVEL) * ElectricConstants.CONVERSION_SPEED)) > 0.0) {
            f.getSource().drainPower(c.applyEnergy(watt));
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public double getIndScale() {
        return 0.07;
    }

    @Override
    public void computeVoltage() {
        this.V += 0.05 * this.I * this.getInvCapacity();
        if (this.V < 0.0 || Double.isNaN(this.V)) {
            this.V = 0.0;
        }
        if (this.V > ElectricConstants.MAX_VOLTAGE * this.getVoltageMultiplier() * 2.0) {
            this.V = ElectricConstants.MAX_VOLTAGE * this.getVoltageMultiplier() * 2.0;
        }
        this.I = 0.0;
        this.Itot = this.Iabs * 0.5;
        this.Iabs = 0.0;
    }

    @Override
    public double getInvCapacity() {
        return this.getVoltageMultiplier() * EnergyConverter.RFtoW(0.1);
    }

    @Override
    public double getIntensity() {
        return this.Itot;
    }

    @Override
    public double getResistance() {
        return this.R;
    }

    @Override
    public double getCondParallel() {
        return 0.5;
    }

    @Override
    public void applyCurrent(double amps) {
        this.getVoltage();
        this.I += amps;
        this.Iabs += Math.abs(amps / this.getVoltageMultiplier());
    }

    @Override
    public void drainPower(double power) {
        double square = this.V * this.V - 0.1 * (power *= this.getVoltageMultiplier());
        double draining = (square < 0.0 ? 0.0 : Math.sqrt(square)) - this.V;
        this.applyCurrent(20.0 * draining);
    }

    @Override
    public void applyPower(double power) {
        double applying = Math.sqrt(this.V * this.V + 0.1 * (power *= this.getVoltageMultiplier())) - this.V;
        this.applyCurrent(20.0 * applying);
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74780_a("Volts", this.V);
        nbt.func_74780_a("Amperes", this.I);
        nbt.func_74780_a("Ohms", this.R);
        nbt.func_74780_a("Iabs", this.Iabs);
        nbt.func_74780_a("Itot", this.Itot);
        nbt.func_74768_a("Vtier", this.tier);
        nbt.func_74772_a("lastTick", this.lastTick);
        if (this.currents != null) {
            nbt.func_74774_a("currents", (byte)this.currents.length);
            for (int j = 0; j < this.currents.length; ++j) {
                nbt.func_74780_a("flow" + j, this.currents[j]);
            }
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.V = nbt.func_74769_h("Volts");
        this.I = nbt.func_74769_h("Amperes");
        this.R = nbt.func_74769_h("Ohms");
        this.Iabs = nbt.func_74769_h("Iabs");
        this.Itot = nbt.func_74769_h("Itot");
        this.tier = nbt.func_74762_e("Vtier");
        this.lastTick = nbt.func_74763_f("lastTick");
        int i = nbt.func_74771_c("currents");
        if (i != 0) {
            this.currents = new double[i];
            for (int j = 0; j < i; ++j) {
                this.currents[j] = nbt.func_74769_h("flow" + j);
            }
        }
    }

    @Override
    public void setResistance(double d) {
        this.R = d;
    }

    @Override
    public void setVoltage(double d) {
        this.V = d;
    }

    @Override
    public int getStorage() {
        return 0;
    }

    @Override
    public int getMaxStorage() {
        return 0;
    }

    @Override
    public void setStorage(int charge) {
    }

    @Override
    public void drainCharge(int charge) {
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public IIndexedConnection[] getConnections() {
        if (this.con == null) {
            return null;
        }
        return this.con.toArray(new IIndexedConnection[this.con.size()]);
    }

    @Override
    public VecInt[] getValidConnections() {
        return VecIntUtil.FORGE_DIRECTIONS;
    }

    @Override
    public boolean isAbleToConnect(IConnectable c, VecInt d) {
        return true;
    }

    @Override
    public void applyCharge(int charge) {
    }

    @Override
    public double getVoltageMultiplier() {
        return this.tier == 0 ? 1.0 : (this.tier == 1 ? 10.0 : (this.tier == 2 ? 100.0 : (this.tier == 3 ? 1000.0 : (this.tier == 4 ? 10000.0 : (this.tier == 5 ? 100000.0 : (this.tier == 6 ? 1000000.0 : 1.0E7))))));
    }

    @Override
    public ConnectionClass getConnectionClass(VecInt v) {
        return ConnectionClass.FULL_BLOCK;
    }

    @Override
    public boolean canFlowPower(IIndexedConnection con) {
        return true;
    }
}

