/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity;

import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricMultiPart;
import com.cout970.magneticraft.api.electricity.IElectricPole;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IIndexedConnection;
import com.cout970.magneticraft.api.electricity.ITileElectricPole;
import com.cout970.magneticraft.api.electricity.InteractionHelper;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;

public class ElectricUtils {
    public static boolean alreadyContains(IIndexedConnection[] con, VecInt opp) {
        if (con == null) {
            return false;
        }
        if (opp == null) {
            return false;
        }
        for (IIndexedConnection i : con) {
            if (!opp.equals(i.getOffset())) continue;
            return true;
        }
        return false;
    }

    public static IElectricConductor[] getElectricCond(TileEntity tile, VecInt f, int tier) {
        if (tile instanceof TileMultipart) {
            List<IElectricConductor> list = ((TileMultipart)tile).jPartList().stream().filter(m -> m instanceof IElectricMultiPart && ((IElectricMultiPart)m).getElectricConductor(tier) != null).map(m -> ((IElectricMultiPart)m).getElectricConductor(tier)).collect(Collectors.toList());
            return list.toArray(new IElectricConductor[list.size()]);
        }
        if (tile instanceof IElectricTile) {
            return ((IElectricTile)tile).getConds(f, tier);
        }
        return null;
    }

    public static IEnergyInterface getInterface(TileEntity t, VecInt i, int tier) {
        return InteractionHelper.processTile(t, i, tier);
    }

    public static boolean isConductor(TileEntity tile, int tier) {
        return ElectricUtils.getElectricCond(tile, VecInt.NULL_VECTOR, tier) != null;
    }

    public static IElectricPole getElectricPole(TileEntity tile) {
        if (tile instanceof ITileElectricPole) {
            if (((ITileElectricPole)tile).getMainTile() == null) {
                return null;
            }
            if (((ITileElectricPole)tile).getMainTile() == tile) {
                return ((ITileElectricPole)tile).getPoleConnection();
            }
            return ((ITileElectricPole)tile).getMainTile().getPoleConnection();
        }
        return null;
    }
}

