/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import com.cout970.magneticraft.world.GaussOreGenConfig;
import com.cout970.magneticraft.world.OreGenConfig;
import com.cout970.magneticraft.world.WorldGenManagerMg;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ManagerConfig {
    public static Configuration config;
    public static boolean MINER_CHUNKLOADING;
    public static int INFINITE_WATER_GENERATION;
    public static boolean CRUSHING_TABLE_DROPS;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file);
            ManagerConfig.LoadConfigs();
        }
    }

    @SubscribeEvent
    public void onconfigurationChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("Magneticraft")) {
            ManagerConfig.LoadConfigs();
        }
    }

    public static void LoadConfigs() {
        config.load();
        WorldGenManagerMg.GenCopper = ManagerConfig.getOreConfig(config, "copper", 10, 8, 80, 30);
        WorldGenManagerMg.GenTungsten = ManagerConfig.getOreConfig(config, "tungsten", 2, 6, 10, 0);
        WorldGenManagerMg.GenSulfur = ManagerConfig.getOreConfig(config, "sulfur", 3, 8, 12, 0);
        WorldGenManagerMg.GenUranium = ManagerConfig.getOreConfig(config, "uranium", 3, 3, 80, 0);
        WorldGenManagerMg.GenThorium = ManagerConfig.getOreConfig(config, "thorium", 5, 6, 20, 0);
        WorldGenManagerMg.GenSalt = ManagerConfig.getOreConfig(config, "salt", 6, 8, 80, 0);
        WorldGenManagerMg.GenZinc = ManagerConfig.getOreConfig(config, "zinc", 4, 6, 80, 0);
        WorldGenManagerMg.GenLime = ManagerConfig.getGaussOreConfig(config, "limestone", 3, 0.9f, 0, 5, 50, 64, 16);
        WorldGenManagerMg.GenOil = config.getBoolean("Oil Generation", "general", true, "Should spawn oil in the world?");
        WorldGenManagerMg.GenOilProbability = config.getInt("Oil Generation Amount", "general", 2000, 200, 50000, "How rare should oil be? Higher value means less oil.");
        WorldGenManagerMg.GenOilMaxHeight = config.getInt("Oil Generation Max Height", "general", 30, 0, 256, "Max Height for a oil deposit");
        WorldGenManagerMg.GenOilMinHeight = config.getInt("Oil Generation Min Height", "general", 10, 0, 256, "Min Height for a oil deposit");
        WorldGenManagerMg.GenOilMaxAmount = config.getInt("Oil Generation Max oil deposits", "general", 9, 1, 16, "Max number of oil deposits nearby");
        MINER_CHUNKLOADING = config.getBoolean("Chunk Loading", "general", true, "Should the miner load chunks?");
        INFINITE_WATER_GENERATION = config.getInt("Infinite water", "general", 50, 0, 1000, "Amount of water generated by a Infinite Water Block every tick");
        CRUSHING_TABLE_DROPS = config.getBoolean("Crushing table drops", "general", false, "When smashing ores drop output as item entities");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static OreGenConfig getOreConfig(Configuration conf, String name, int chunk, int vein, int max, int min) {
        boolean active = conf.getBoolean(name + "_gen_active", "general", true, "Generation of " + name);
        int amount_per_chunk = conf.getInt(name + "_amount_chunk", "general", chunk, 0, 20, "Number of veins of " + name + " per chunk");
        int amount_per_vein = conf.getInt(name + "_amount_vein", "general", vein, 0, 20, "Max amount of blocks of " + name + " in a vein");
        int max_height = conf.getInt(name + "_max_height", "general", max, 0, 256, "Max height for generation of " + name);
        int min_height = conf.getInt(name + "_min_height", "general", min, 0, 256, "Min height for generation of " + name);
        return new OreGenConfig(active, amount_per_chunk, amount_per_vein, max_height, min_height);
    }

    private static GaussOreGenConfig getGaussOreConfig(Configuration conf, String name, int chunk, float deviation, int min_am, int max_am, int vein, int max, int min) {
        boolean active = conf.getBoolean(name + "_gen_active", "general", true, "Generation of " + name);
        int amount_per_chunk = conf.getInt(name + "_amount_chunk", "general", chunk, 0, 30, "Average number of veins of " + name + " per chunk");
        float amount_deviation = conf.getFloat(name + "_std_dev", "general", deviation, 0.0f, 10.0f, "Standard deviation of number of veins per chunk.\nHigher value means more chunks with low/high amounts of veins, lower - more with medium amount");
        int min_chunk = conf.getInt(name + "_min_per_chunk", "general", min_am, 0, amount_per_chunk, "Minimal amount of veins per chunk");
        int max_chunk = conf.getInt(name + "_max_per_chunk", "general", max_am, 0, 100, "Maximal amount of veins per chunk");
        int amount_per_vein = conf.getInt(name + "_amount_vein", "general", vein, 0, 50, "Max amount of blocks of " + name + " in a vein");
        int max_height = conf.getInt(name + "_max_height", "general", max, 0, 256, "Max height for generation of " + name);
        int min_height = conf.getInt(name + "_min_height", "general", min, 0, 256, "Min height for generation of " + name);
        return new GaussOreGenConfig(active, amount_per_chunk, amount_deviation, min_chunk, max_chunk, amount_per_vein, max_height, min_height);
    }
}

