/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import com.cout970.magneticraft.LangHelper;
import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.ManagerConfig;
import com.cout970.magneticraft.ManagerCraft;
import com.cout970.magneticraft.ManagerFluids;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.ManagerMultiPart;
import com.cout970.magneticraft.ManagerNetwork;
import com.cout970.magneticraft.ManagerOreDict;
import com.cout970.magneticraft.ManagerRecipe;
import com.cout970.magneticraft.compat.ManagerIntegration;
import com.cout970.magneticraft.compat.minetweaker.MgMinetweaker;
import com.cout970.magneticraft.handlers.GuiHandler;
import com.cout970.magneticraft.handlers.HandlerBuckets;
import com.cout970.magneticraft.handlers.SolidFuelHandler;
import com.cout970.magneticraft.proxy.IProxy;
import com.cout970.magneticraft.tileentity.TileMiner;
import com.cout970.magneticraft.util.Log;
import com.cout970.magneticraft.util.URLConnectionReader;
import com.cout970.magneticraft.util.energy.EnergyInterfaceFactory;
import com.cout970.magneticraft.util.multiblock.MB_Register;
import com.cout970.magneticraft.world.WorldGenManagerMg;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Magneticraft", name="Magneticraft", version="0.6.0-beta2", guiFactory="com.cout970.magneticraft.handlers.MgGuiFactory", dependencies="required-after:ForgeMultipart;after:BuildCraft|Core;after:CoFHCore;after:IC2;after:Railcraft;after:ImmersiveEngineering")
public class Magneticraft {
    public static final String ID = "Magneticraft";
    public static final String NAME = "Magneticraft";
    public static final String VERSION = "0.6.0-beta2";
    public static final String MIN_JAVA = "Java 8";
    public static final String ENERGY_STORED_NAME = "J";
    public static final String GUI_FACTORY = "com.cout970.magneticraft.handlers.MgGuiFactory";
    public static final boolean DEBUG = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static String DEV_HOME = null;
    public static boolean BUILDCRAFT = false;
    public static boolean RAILCRAFT = false;
    public static boolean IC2 = false;
    public static boolean COFH_ENERGY = false;
    public static boolean COFH_TOOLS = false;
    public static boolean IE = false;
    @Mod.Instance(value="Magneticraft")
    public static Magneticraft INSTANCE;
    @SidedProxy(clientSide="com.cout970.magneticraft.proxy.ClientProxy", serverSide="com.cout970.magneticraft.proxy.ServerProxy")
    public static IProxy proxy;
    public static ManagerMultiPart registry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Log.init(event.getModLog());
        Log.info("Starting preInit");
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            BUILDCRAFT = true;
        }
        if (Loader.isModLoaded((String)"IC2")) {
            IC2 = true;
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            RAILCRAFT = true;
        }
        if (Loader.isModLoaded((String)"ImmersiveEngineering")) {
            IE = true;
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy")) {
            COFH_ENERGY = true;
        }
        if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI|item")) {
            COFH_TOOLS = true;
        }
        ManagerConfig.init(event.getSuggestedConfigurationFile());
        ManagerBlocks.initBlocks();
        ManagerBlocks.registerBlocks();
        ManagerBlocks.registerTileEntities();
        ManagerItems.initItems();
        ManagerItems.registerItems();
        ManagerFluids.initFluids();
        proxy.init();
        ManagerIntegration.searchCompatibilities();
        if (DEBUG) {
            for (File temp = event.getModConfigurationDirectory(); temp != null && temp.isDirectory(); temp = temp.getParentFile()) {
                if (!new File(temp, "build.gradle").exists()) continue;
                DEV_HOME = temp.getAbsolutePath();
                Log.info("Found source code directory at " + DEV_HOME);
                break;
            }
            if (DEV_HOME == null) {
                throw new RuntimeException("Could not find source code directory!");
            }
            LangHelper.registerNames();
            LangHelper.setupLangFile();
        }
        ManagerOreDict.registerOreDict();
        Log.info("preInit Done");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Log.info("Starting Init");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        MB_Register.init();
        EnergyInterfaceFactory.init();
        registry = new ManagerMultiPart();
        registry.init();
        GameRegistry.registerFuelHandler((IFuelHandler)new SolidFuelHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenManagerMg(), (int)11);
        ManagerCraft.init();
        ManagerRecipe.registerFurnaceRecipes();
        ManagerRecipe.registerThermopileRecipes();
        ManagerRecipe.registerBiomassBurnerRecipes();
        ManagerNetwork.registerMessages();
        ManagerFluids.registerFuels();
        HandlerBuckets.INSTANCE = new HandlerBuckets();
        MinecraftForge.EVENT_BUS.register((Object)HandlerBuckets.INSTANCE);
        this.checkVersion();
        Log.info("Init Done");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Log.info("Starting postInit");
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            Log.info("Seting up minetweaker compatibility");
            MgMinetweaker.init();
        }
        if (BUILDCRAFT) {
            ManagerFluids.registerBCFuels();
        }
        if (RAILCRAFT) {
            ManagerFluids.registerRCFuels();
        }
        if (IE) {
            ManagerFluids.registerIEFuels();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (ForgeChunkManager.LoadingCallback)new MinerChunkCallBack());
        Log.info("postInit Done");
    }

    public void checkVersion() {
        try {
            String version = URLConnectionReader.getText("https://raw.githubusercontent.com/cout970/Versions/master/MgVersion.txt");
            Log.info("Last Version: " + version);
            Log.info("Current Version: 0.6.0-beta2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void deleteOldBlocks(FMLMissingMappingsEvent event) {
        event.get().stream().forEach(FMLMissingMappingsEvent.MissingMapping::ignore);
    }

    public class MinerChunkCallBack
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int z;
                int y;
                int x = ticket.getModData().func_74762_e("quarryX");
                TileEntity tq = world.func_147438_o(x, y = ticket.getModData().func_74762_e("quarryY"), z = ticket.getModData().func_74762_e("quarryZ"));
                if (!(tq instanceof TileMiner)) continue;
                ((TileMiner)tq).forceChunkLoading(ticket);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            if (ManagerConfig.MINER_CHUNKLOADING) {
                for (ForgeChunkManager.Ticket ticket : tickets) {
                    int z;
                    int y;
                    int x = ticket.getModData().func_74762_e("quarryX");
                    Block block = world.func_147439_a(x, y = ticket.getModData().func_74762_e("quarryY"), z = ticket.getModData().func_74762_e("quarryZ"));
                    if (block != ManagerBlocks.miner) continue;
                    validTickets.add(ticket);
                }
            }
            return validTickets;
        }
    }
}

