/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import com.udojava.evalex.Expression;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.math.BigDecimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.items.ItemFoodContainer;

public class FoodModifier {
    public static final FoodModifier GLOBAL = new FoodModifier();
    public Expression expression;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getFoodValues(FoodEvent.GetPlayerFoodValues event) {
        if (ModConfig.FOOD_MODIFIER_ENABLED) {
            FoodValues modifiedFoodValues;
            ItemStack actualFood = event.food;
            if (FoodHelper.isFoodContainer(event.food)) {
                actualFood = ((ItemFoodContainer)event.food.func_77973_b()).getBestFoodForPlayerToEat(event.food, event.player);
            }
            float modifier = FoodModifier.getFoodModifier(event.player, actualFood);
            event.foodValues = modifiedFoodValues = FoodModifier.getModifiedFoodValues(event.foodValues, modifier);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getFoodEatingSpeed(PlayerUseItemEvent.Start event) {
        if (ModConfig.FOOD_EATING_SPEED_MODIFIER > 0.0f && AppleCoreAPI.accessor.isFood(event.item)) {
            float nutritionalValue;
            float denominator;
            ItemStack actualFood = event.item;
            if (FoodHelper.isFoodContainer(event.item)) {
                actualFood = ((ItemFoodContainer)event.item.func_77973_b()).getBestFoodForPlayerToEat(event.item, event.entityPlayer);
            }
            event.duration = (denominator = (float)Math.pow(nutritionalValue = FoodModifier.getFoodModifier(event.entityPlayer, actualFood), ModConfig.FOOD_EATING_SPEED_MODIFIER)) > 0.0f ? (int)((float)event.duration / denominator) : Short.MAX_VALUE;
            if (ModConfig.FOOD_EATING_DURATION_MAX > 0) {
                event.duration = Math.max(event.duration, ModConfig.FOOD_EATING_DURATION_MAX);
            }
        }
    }

    public FoodModifier() {
        this(ModConfig.FOOD_MODIFIER_FORMULA);
    }

    public FoodModifier(String formula) {
        this.setFormula(formula);
    }

    public void setFormula(String formula) {
        this.expression = new Expression(formula);
    }

    public static void onGlobalFormulaChanged() {
        GLOBAL.setFormula(ModConfig.FOOD_MODIFIER_FORMULA);
    }

    public static float getFoodGroupModifier(FoodHistory foodHistory, ItemStack food, FoodGroup foodGroup) {
        FoodModifier effectiveFoodModifier = foodGroup != null ? foodGroup.getFoodModifier() : GLOBAL;
        int count = foodHistory.getFoodCountForFoodGroup(food, foodGroup);
        int historySize = foodHistory.getHistoryLengthInRelevantUnits();
        FoodValues totalFoodValues = foodHistory.getTotalFoodValuesForFoodGroup(food, foodGroup);
        FoodValues foodValues = FoodValues.get((ItemStack)food);
        BigDecimal result = effectiveFoodModifier.expression.with("count", new BigDecimal(count)).and("cur_history_length", new BigDecimal(historySize)).and("food_hunger_value", new BigDecimal(foodValues.hunger)).and("food_saturation_mod", new BigDecimal(foodValues.saturationModifier)).and("cur_hunger", new BigDecimal(foodHistory.player.func_71024_bL().func_75116_a())).and("cur_saturation", new BigDecimal(foodHistory.player.func_71024_bL().func_75115_e())).and("total_food_eaten", new BigDecimal(foodHistory.totalFoodsEatenAllTime)).and("max_history_length", new BigDecimal(ModConfig.FOOD_HISTORY_LENGTH)).and("hunger_count", new BigDecimal(totalFoodValues.hunger)).and("saturation_count", new BigDecimal(totalFoodValues.saturationModifier)).and("food_group_count", new BigDecimal(FoodGroupRegistry.getFoodGroupsForFood(food).size())).and("distinct_food_groups_eaten", new BigDecimal(foodHistory.getDistinctFoodGroups().size())).and("total_food_groups", new BigDecimal(FoodGroupRegistry.numFoodGroups())).eval();
        return result.floatValue();
    }

    public static float getFoodModifier(EntityPlayer player, ItemStack food) {
        return FoodModifier.getFoodModifier(FoodHistory.get(player), food);
    }

    public static float getFoodModifier(FoodHistory foodHistory, ItemStack food) {
        if (!ModConfig.FOOD_MODIFIER_ENABLED) {
            return 1.0f;
        }
        if (!FoodHelper.canFoodDiminish(food)) {
            return 1.0f;
        }
        if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && foodHistory.totalFoodsEatenAllTime < ModConfig.FOOD_EATEN_THRESHOLD) {
            return 1.0f;
        }
        FoodGroup[] foodGroups = FoodGroupRegistry.getFoodGroupsForFood(food).toArray(new FoodGroup[0]);
        int numIterations = Math.max(1, foodGroups.length);
        float modifierSum = 0.0f;
        for (int i = 0; i < numIterations; ++i) {
            FoodGroup foodGroup = i < foodGroups.length ? foodGroups[i] : null;
            modifierSum += FoodModifier.getFoodGroupModifier(foodHistory, food, foodGroup);
        }
        return modifierSum / (float)numIterations;
    }

    public static FoodValues getModifiedFoodValues(FoodValues foodValues, float modifier) {
        int hunger = foodValues.hunger;
        float saturationModifier = foodValues.saturationModifier;
        if (ModConfig.AFFECT_FOOD_HUNGER_VALUES) {
            if (hunger < 0 && ModConfig.AFFECT_NEGATIVE_FOOD_HUNGER_VALUES) {
                hunger = (int)ModConfig.FOOD_HUNGER_ROUNDING_MODE.round((float)hunger * (2.0f - modifier));
            } else if (hunger > 0) {
                hunger = (int)ModConfig.FOOD_HUNGER_ROUNDING_MODE.round((float)hunger * modifier);
            }
        }
        if (ModConfig.AFFECT_FOOD_SATURATION_MODIFIERS) {
            if (saturationModifier < 0.0f && ModConfig.AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS) {
                saturationModifier *= 2.0f - modifier;
            } else if (saturationModifier > 0.0f) {
                saturationModifier *= modifier;
            }
        }
        return new FoodValues(hunger, saturationModifier);
    }
}

