/*
 * Decompiled with CFR 0.152.
 */
package org.devinprogress.uniskinmod;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.devinprogress.uniskinmod.CoreContainer;
import org.devinprogress.uniskinmod.CoreTransformer;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class SkinCore
implements IFMLLoadingPlugin {
    public static boolean ObfuscatedEnv = true;
    private static SkinCore instance = null;
    private List<String> SkinURLs = new ArrayList<String>();
    private List<String> CapeURLs = new ArrayList<String>();
    private static final String CFG_VER_STR = "Version: 1";
    private static String SkinCachePath = "";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SkinCore() {
        if (instance != null) {
            throw new RuntimeException("Duplicated Initialization for SkinCore");
        }
        instance = this;
    }

    public static SkinCore getInstance() {
        if (instance == null) {
            throw new RuntimeException("SkinCore.getInstance() before constructor");
        }
        return instance;
    }

    public String[] getASMTransformerClass() {
        return new String[]{CoreTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return CoreContainer.class.getName();
    }

    public String getSetupClass() {
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        LogManager.getLogger((String)"UniSkinMod").info("Injecting Data ...");
        ObfuscatedEnv = (Boolean)data.get("runtimeDeobfuscationEnabled");
        String cfgPath = ((File)data.get("mcLocation")).getAbsolutePath() + File.separatorChar + "config" + File.separatorChar + "UniSkinMod.cfg";
        this.updateCfg(cfgPath);
        this.loadCfg(cfgPath);
        SkinCachePath = ((File)data.get("mcLocation")).getAbsolutePath() + File.separatorChar + "assets" + File.separatorChar + "skins";
        if (System.getProperty("uniskinmod.forceCleanUp", "false").equals("true")) {
            File skin_dir = new File(SkinCachePath);
            try {
                FileUtils.deleteDirectory((File)skin_dir);
                LogManager.getLogger((String)"UniSkinMod").info("Skin cache cleaned.");
            }
            catch (IOException e) {
                LogManager.getLogger((String)"UniSkinMod").warn("Failed to clean cache.");
                e.printStackTrace();
            }
        }
    }

    private void updateCfg(String cfgPath) {
        try {
            File cfgFile = new File(cfgPath);
            if (cfgFile.exists()) {
                FileReader fr = new FileReader(cfgPath);
                BufferedReader br = new BufferedReader(fr);
                String headLine = "";
                while (headLine.equals("") && br.ready()) {
                    headLine = br.readLine();
                }
                br.close();
                fr.close();
                if (!headLine.equals(CFG_VER_STR)) {
                    LogManager.getLogger((String)"UniSkinMod").warn("Configure file version not match, deleting ...");
                    cfgFile.delete();
                }
            }
            if (!cfgFile.exists()) {
                LogManager.getLogger((String)"UniSkinMod").warn("Configure file do not exists. Creating...");
                cfgFile.createNewFile();
                FileWriter fw = new FileWriter(cfgPath);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(CFG_VER_STR);
                bw.newLine();
                bw.write("#Do not edit the line above");
                bw.newLine();
                bw.write("#\u8bf7\u52ff\u968f\u610f\u4fee\u6539\u4ee5\u4e0a\u4e24\u884c");
                bw.newLine();
                bw.write("Skin: http://www.skinme.cc/MinecraftSkins/%s.png");
                bw.newLine();
                bw.write("Cape: http://www.skinme.cc/MinecraftCloaks/%s.png");
                bw.newLine();
                bw.write("Skin: http://skins.minecraft.net/MinecraftSkins/%s.png");
                bw.newLine();
                bw.write("Cape: http://skins.minecraft.net/MinecraftCloaks/%s.png");
                bw.newLine();
                bw.flush();
                bw.close();
                fw.close();
            }
        }
        catch (IOException e) {
            LogManager.getLogger((String)"UniSkinMod").warn("Error happened when updating configuration");
            e.printStackTrace();
        }
    }

    private void loadCfg(String cfgPath) {
        try {
            FileReader fr = new FileReader(cfgPath);
            BufferedReader br = new BufferedReader(fr);
            while (br.ready()) {
                String theLine = br.readLine().trim();
                if (theLine.startsWith("#") || theLine.equals("")) continue;
                if (theLine.startsWith("Cape: ")) {
                    this.CapeURLs.add(theLine.substring(6).trim());
                    continue;
                }
                if (!theLine.startsWith("Skin: ")) continue;
                this.SkinURLs.add(theLine.substring(6).trim());
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            LogManager.getLogger((String)"UniSkinMod").warn("Error happened when loading configuration");
            e.printStackTrace();
        }
    }

    public static void injectTexture(HashMap map, GameProfile profile) {
        LogManager.getLogger((String)"UniSkinMod").info("Invoked for Player: " + profile.getName());
        if (map.containsKey(MinecraftProfileTexture.Type.CAPE) && map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return;
        }
        playerSkinData data = SkinCore.getInstance().getPlayerData(profile.getName(), profile.getId().toString());
        if (!map.containsKey(MinecraftProfileTexture.Type.CAPE) && data.cape != null) {
            map.put(MinecraftProfileTexture.Type.CAPE, new MinecraftProfileTexture(data.cape));
        }
        if (!map.containsKey(MinecraftProfileTexture.Type.SKIN) && data.skin != null) {
            map.put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(data.skin));
        }
    }

    public playerSkinData getPlayerData(String name, String uuid) {
        String skinURL = this.testURLs(name, this.SkinURLs);
        String capeURL = this.testURLs(name, this.CapeURLs);
        String model = "default";
        return new playerSkinData(skinURL, capeURL, model);
    }

    private String testURLs(String playerName, List<String> templates) {
        String CachedLink = null;
        for (String s : templates) {
            String link = String.format(s, playerName);
            int rspCode = 0;
            try {
                URL url = new URL(link);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(false);
                conn.setConnectTimeout(5000);
                conn.setInstanceFollowRedirects(true);
                conn.connect();
                rspCode = conn.getResponseCode();
                conn.disconnect();
            }
            catch (IOException e) {
                rspCode = -1;
            }
            if (rspCode == 404) {
                SkinCore.cleanCache(link);
            }
            if (rspCode == 200) {
                SkinCore.cleanCache(link);
                return link;
            }
            if (CachedLink != null || !SkinCore.cacheExists(link)) continue;
            CachedLink = link;
        }
        return CachedLink;
    }

    private static boolean cacheExists(String link) {
        String hash = SkinCore.getHashForTexture(link);
        String domain = hash.substring(0, 2);
        File t = new File(SkinCachePath + File.separator + domain + File.separator + hash);
        return t.exists();
    }

    private static void cleanCache(String link) {
        String hash = SkinCore.getHashForTexture(link);
        String domain = hash.substring(0, 2);
        File t = new File(SkinCachePath + File.separator + domain + File.separator + hash);
        if (t.exists() && !t.delete()) {
            LogManager.getLogger((String)"UniSkinMod").warn("Failed to delete cache: " + link);
        }
    }

    public static String getHashForTexture(String url) {
        return SkinCore.SHA1SUM(url);
    }

    public static String SHA1SUM(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(str.getBytes());
            return SkinCore.toHex(messageDigest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "MissingTexture";
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    private class playerSkinData {
        public String skin;
        public String cape;
        public String model;

        public playerSkinData(String skinURL, String capeURL, String model) {
            this.skin = skinURL;
            this.cape = capeURL;
            this.model = model == null ? "default" : (model.equalsIgnoreCase("alex") ? "alex" : "default");
        }
    }
}

