/*
 * Decompiled with CFR 0.152.
 */
package org.devinprogress.uniskinmod;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    private Object obj;
    private Map<String, Map<String, Method>> map;

    public ASMHelper(Object o) {
        this.obj = o;
        this.map = new HashMap<String, Map<String, Method>>();
    }

    public void hookMethod(String className, String srgName, String mcpName, String desc, String targetTransformer) {
        if (!this.map.containsKey(className)) {
            this.map.put(className, new HashMap());
        }
        Method m = null;
        try {
            m = this.obj.getClass().getDeclaredMethod(targetTransformer, MethodNode.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.map.get(className).put(srgName + desc, m);
        this.map.get(className).put(mcpName + desc, m);
    }

    public byte[] transform(String obfClassName, String className, byte[] bytes) {
        if (!this.map.containsKey(className)) {
            return bytes;
        }
        Map<String, Method> transMap = this.map.get(className);
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            String methodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(obfClassName, mn.name, mn.desc);
            String methodDesc = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(mn.desc);
            if (!transMap.containsKey(methodName + methodDesc)) continue;
            try {
                transMap.get(methodName + methodDesc).invoke(this.obj, mn);
            }
            catch (Exception e) {
                e.printStackTrace();
                return bytes;
            }
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static AbstractInsnNode getNthInsnNode(MethodNode mn, int opcode, int N) {
        AbstractInsnNode n;
        int count = 0;
        for (n = mn.instructions.getFirst(); n != null && (n.getOpcode() != opcode || ++count != N); n = n.getNext()) {
        }
        return n;
    }

    public static AbstractInsnNode getLabel(AbstractInsnNode n) {
        if (!(n instanceof JumpInsnNode)) {
            throw new RuntimeException("Not a valid JumpInsnNode");
        }
        return ((JumpInsnNode)n).label;
    }

    public static void InsertInvokeStaticBefore(MethodNode mn, AbstractInsnNode n, String targetClass, String targetMethod, String desc) {
        mn.instructions.insertBefore(n, (AbstractInsnNode)new MethodInsnNode(184, targetClass.replace('.', '/'), targetMethod, desc, false));
    }
}

