/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.gui.GuiBiblioTextField;
import jds.bibliocraft.gui.GuiButtonClipboard;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiBigBook
extends GuiScreen {
    private int defaultTextScale = Config.defaultBigBookTextScale;
    private int bookImageWidth = 220;
    private int bookImageHeight = 256;
    private int spacing = 30;
    private ItemStack book;
    private boolean isinhand;
    private int tilex = 0;
    private int tiley = 0;
    private int tilez = 0;
    private GuiButton buttonSignAccept;
    private GuiButton buttonSignCancel;
    private GuiBiblioTextField signTextField;
    private String signingInstruct = "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"book.entertitle");
    private String signingNotice = "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"book.signnotice");
    private String signedBy = "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"book.by");
    private String signedAuthor = "";
    private boolean signing = false;
    private boolean signed = false;
    private GuiButton buttonSave;
    private GuiButton buttonSign;
    private GuiButton buttonBold;
    private GuiButton buttonItalic;
    private GuiButton buttonUnderline;
    private GuiButton buttonStrike;
    private GuiButton buttonObfusticate;
    private GuiButton buttonReset;
    private GuiButtonClipboard colorMockButton;
    private GuiButtonClipboard buttonPageBack;
    private GuiButtonClipboard buttonPageForward;
    private GuiButtonClipboard buttonPageFirst;
    private GuiButtonClipboard buttonPageLast;
    private GuiButton buttonScalePlus;
    private GuiButton buttonScaleNeg;
    private int currentLine = 0;
    private int currentLineCursorPos = 1;
    private String textScale = StatCollector.func_74838_a((String)"book.textscale");
    private String lineSelected = StatCollector.func_74838_a((String)"book.lineselected");
    private String[] textScaling = new String[]{"0.5x", "0.65x", "0.8x", "1.0x", "1.2x", "1.4x", "1.75x", "2.0x"};
    private String[][] mods = new String[4][4];
    private GuiBiblioTextField[] lines = new GuiBiblioTextField[44];
    private int[] lineScales = new int[44];
    private String[] lineTexts = new String[44];
    private GuiBiblioTextField[] chapters = new GuiBiblioTextField[16];
    private boolean[] chapterBool = new boolean[]{false, false, false, false, false, false, false, false};
    private int[] chapterPageNums = new int[8];
    private String[] chapterNames = new String[16];
    private float[] scales = new float[]{0.5f, 0.65f, 0.8f, 1.0f, 1.2f, 1.4f, 1.75f, 2.0f};
    private float[] antiscales = new float[]{1.0f / this.scales[0], 1.0f / this.scales[1], 1.0f / this.scales[2], 1.0f / this.scales[3], 1.0f / this.scales[4], 1.0f / this.scales[5], 1.0f / this.scales[6], 1.0f / this.scales[7]};
    private int[] scaledLinesNumber = new int[]{44, 34, 27, 22, 18, 16, 12, 11};
    private float lineCounter = 0.0f;
    private int numOfLines = 1;
    private int linespace = 0;
    private int currentPage = 0;
    private int totalPages = 1;
    private String pagesTextLine = "";
    private int widthLocal;
    private int heightLocal;
    private boolean isInitialized = false;

    public GuiBigBook(ItemStack bigbook, boolean inhand, int tx, int ty, int tz) {
        this.book = bigbook;
        this.isinhand = inhand;
        this.mods[0][0] = "" + EnumChatFormatting.BLACK;
        this.mods[0][1] = "" + EnumChatFormatting.DARK_BLUE;
        this.mods[0][2] = "" + EnumChatFormatting.DARK_GREEN;
        this.mods[0][3] = "" + EnumChatFormatting.DARK_AQUA;
        this.mods[1][0] = "" + EnumChatFormatting.DARK_RED;
        this.mods[1][1] = "" + EnumChatFormatting.DARK_PURPLE;
        this.mods[1][2] = "" + EnumChatFormatting.GOLD;
        this.mods[1][3] = "" + EnumChatFormatting.GRAY;
        this.mods[2][0] = "" + EnumChatFormatting.DARK_GRAY;
        this.mods[2][1] = "" + EnumChatFormatting.BLUE;
        this.mods[2][2] = "" + EnumChatFormatting.GREEN;
        this.mods[2][3] = "" + EnumChatFormatting.AQUA;
        this.mods[3][0] = "" + EnumChatFormatting.RED;
        this.mods[3][1] = "" + EnumChatFormatting.LIGHT_PURPLE;
        this.mods[3][2] = "" + EnumChatFormatting.YELLOW;
        this.mods[3][3] = "" + EnumChatFormatting.WHITE;
        for (int n = 0; n < 44; ++n) {
        }
        NBTTagCompound tags = this.book.func_77978_p();
        if (tags != null) {
            this.totalPages = tags.func_74762_e("pagesTotal");
            this.currentPage = tags.func_74762_e("pagesCurrent");
            this.signedAuthor = tags.func_74779_i("author");
            this.signed = tags.func_74767_n("signed");
            if (this.totalPages == 0) {
                this.totalPages = 1;
            }
        }
        this.loadCurrentPageLinesFromNBT();
        if (!inhand) {
            this.tilex = tx;
            this.tiley = ty;
            this.tilez = tz;
        }
    }

    public void func_146280_a(Minecraft p_146280_1_, int p_146280_2_, int p_146280_3_) {
        if (this.isInitialized) {
            this.saveLinesToList();
        } else {
            this.isInitialized = true;
        }
        this.field_146297_k = p_146280_1_;
        this.field_146289_q = p_146280_1_.field_71466_p;
        this.field_146294_l = p_146280_2_;
        this.field_146295_m = p_146280_3_;
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Pre((GuiScreen)this, this.field_146292_n))) {
            this.field_146292_n.clear();
            this.func_73866_w_();
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.InitGuiEvent.Post((GuiScreen)this, this.field_146292_n));
    }

    public void loadCurrentPageLinesFromNBT() {
        NBTTagCompound tags = this.book.func_77978_p();
        if (tags != null) {
            NBTTagCompound chapTag;
            NBTTagCompound pagesTag = tags.func_74775_l("pages");
            if (pagesTag != null) {
                int n;
                NBTTagList nbtLines = pagesTag.func_150295_c("page" + this.currentPage, 8);
                if (nbtLines != null) {
                    for (n = 0; n < 44; ++n) {
                        this.lineTexts[n] = nbtLines.func_150307_f(n);
                    }
                    this.lineScales = pagesTag.func_74759_k("pageScale" + this.currentPage);
                    if (this.lineScales.length != 44 || this.lineTexts.length != 44) {
                        this.lineTexts = new String[44];
                        this.lineScales = new int[44];
                        for (n = 0; n < 44; ++n) {
                            this.lineTexts[n] = "";
                            this.lineScales[n] = this.defaultTextScale;
                        }
                    }
                } else {
                    for (n = 0; n < 44; ++n) {
                        this.lineTexts[n] = "";
                        this.lineScales[n] = this.defaultTextScale;
                    }
                }
            }
            if ((chapTag = tags.func_74775_l("chapters")) != null) {
                int n;
                int[] bools;
                this.chapterPageNums = chapTag.func_74759_k("chapPages");
                if (this.chapterPageNums.length != 8) {
                    this.chapterPageNums = new int[8];
                }
                if ((bools = chapTag.func_74759_k("chapBools")).length == 8) {
                    for (n = 0; n < 8; ++n) {
                        this.chapterBool[n] = bools[n] == 1;
                    }
                } else {
                    this.chapterBool = new boolean[8];
                }
                for (n = 0; n < 16; ++n) {
                    this.chapterNames[n] = chapTag.func_74779_i("chapline" + n);
                }
                if (this.chapterNames.length != 16) {
                    this.chapterNames = new String[16];
                }
            }
        }
    }

    public void saveCurrentPageToNBT() {
        int n;
        NBTTagCompound pagesTag;
        NBTTagCompound tags = this.book.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
        }
        if ((pagesTag = tags.func_74775_l("pages")) == null) {
            pagesTag = new NBTTagCompound();
        }
        tags.func_74768_a("pagesTotal", this.totalPages);
        tags.func_74768_a("pagesCurrent", this.currentPage);
        NBTTagList nbtLines = new NBTTagList();
        for (int n2 = 0; n2 < 44; ++n2) {
            nbtLines.func_74742_a((NBTBase)new NBTTagString(this.lines[n2].getText()));
        }
        pagesTag.func_74783_a("pageScale" + this.currentPage, this.lineScales);
        pagesTag.func_74782_a("page" + this.currentPage, (NBTBase)nbtLines);
        NBTTagCompound chapterNBT = new NBTTagCompound();
        int[] chapbools = new int[8];
        for (n = 0; n < 8; ++n) {
            chapbools[n] = this.chapterBool[n] ? 1 : 0;
        }
        for (n = 0; n < 16; ++n) {
            chapterNBT.func_74778_a("chapline" + n, this.chapters[n].getText());
        }
        chapterNBT.func_74783_a("chapBools", chapbools);
        chapterNBT.func_74783_a("chapPages", this.chapterPageNums);
        tags.func_74782_a("pages", (NBTBase)pagesTag);
        tags.func_74782_a("chapters", (NBTBase)chapterNBT);
        this.book.func_77982_d(tags);
    }

    public void saveSigningToNBT() {
        NBTTagCompound tags = this.book.func_77978_p();
        if (tags != null) {
            tags.func_74757_a("signed", this.signed);
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", EnumChatFormatting.WHITE + this.signTextField.getText());
            tags.func_74782_a("display", (NBTBase)display);
            this.book.func_77982_d(tags);
        }
    }

    public void func_73866_w_() {
        int n;
        super.func_73866_w_();
        this.widthLocal = (this.field_146294_l - this.bookImageWidth) / 2;
        this.heightLocal = (this.field_146295_m - this.bookImageHeight) / 2;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        if (!this.signed && !this.signing) {
            this.buttonBold = new GuiButton(10, this.widthLocal - 60, this.heightLocal + 25, 20, 20, EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"book.bold"));
            this.field_146292_n.add(this.buttonBold);
            this.buttonItalic = new GuiButton(11, this.widthLocal - 40, this.heightLocal + 25, 20, 20, EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"book.italic"));
            this.field_146292_n.add(this.buttonItalic);
            this.buttonUnderline = new GuiButton(12, this.widthLocal - 20, this.heightLocal + 25, 20, 20, EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"book.underline"));
            this.field_146292_n.add(this.buttonUnderline);
            this.buttonStrike = new GuiButton(13, this.widthLocal - 60, this.heightLocal + 45, 40, 20, EnumChatFormatting.STRIKETHROUGH + StatCollector.func_74838_a((String)"book.strike"));
            this.field_146292_n.add(this.buttonStrike);
            this.buttonObfusticate = new GuiButton(14, this.widthLocal - 20, this.heightLocal + 45, 20, 20, EnumChatFormatting.OBFUSCATED + StatCollector.func_74838_a((String)"book.obfuscated"));
            this.field_146292_n.add(this.buttonObfusticate);
            this.buttonReset = new GuiButton(15, this.widthLocal - 60, this.heightLocal + 118, 60, 20, StatCollector.func_74838_a((String)"book.reset"));
            this.field_146292_n.add(this.buttonReset);
            this.colorMockButton = new GuiButtonClipboard(9, this.widthLocal - 60, this.heightLocal + 65, 60, 53, "", false);
            this.field_146292_n.add(this.colorMockButton);
            this.buttonScalePlus = new GuiButton(16, this.widthLocal - 20, this.heightLocal + 154, 20, 20, "+");
            this.field_146292_n.add(this.buttonScalePlus);
            this.buttonScaleNeg = new GuiButton(17, this.widthLocal - 60, this.heightLocal + 154, 20, 20, "-");
            this.field_146292_n.add(this.buttonScaleNeg);
            this.buttonSave = new GuiButton(0, this.widthLocal - 60, this.heightLocal + 228, 60, 20, StatCollector.func_74838_a((String)"book.save"));
            this.field_146292_n.add(this.buttonSave);
            this.buttonSign = new GuiButton(1, this.widthLocal - 60, this.heightLocal + 204, 60, 20, StatCollector.func_74838_a((String)"book.sign"));
            this.field_146292_n.add(this.buttonSign);
        }
        this.buttonPageBack = new GuiButtonClipboard(18, this.widthLocal + 45, this.heightLocal + 234, 20, 12, "", false);
        this.field_146292_n.add(this.buttonPageBack);
        this.buttonPageForward = new GuiButtonClipboard(19, this.widthLocal + 150, this.heightLocal + 234, 20, 12, "", false);
        this.field_146292_n.add(this.buttonPageForward);
        this.buttonPageFirst = new GuiButtonClipboard(20, this.widthLocal + 15, this.heightLocal + 234, 20, 12, "", false);
        this.field_146292_n.add(this.buttonPageFirst);
        this.buttonPageLast = new GuiButtonClipboard(21, this.widthLocal + 178, this.heightLocal + 234, 20, 12, "", false);
        this.field_146292_n.add(this.buttonPageLast);
        this.numOfLines = 0;
        this.lineCounter = 0.0f;
        this.linespace = 0;
        for (n = 0; n < 44; ++n) {
            this.lines[n] = new GuiBiblioTextField(this.field_146289_q, (int)((float)(this.widthLocal + 15) * this.antiscales[this.lineScales[n]]), (int)((float)(this.heightLocal + 15) * this.antiscales[this.lineScales[n]] + (float)this.linespace * this.antiscales[this.lineScales[n]]), (int)(193.0f * this.antiscales[this.lineScales[n]]), 8);
            this.lines[n].setEnableBackgroundDrawing(false);
            this.lines[n].setMaxStringLength(200);
            this.lines[n].setTextColor(0);
            if (n < this.lineTexts.length && this.lineTexts[n] != null) {
                this.lines[n].setText(this.lineTexts[n]);
            }
            String textTest = this.lines[n].getText();
            int formcount = 0;
            if (textTest.length() > 0) {
                for (int m = 0; m < textTest.length(); ++m) {
                    if (!textTest.substring(m, m + 1).contains("\u00a7")) continue;
                    ++formcount;
                }
            }
            this.lines[n].setMaxStringLength((int)((float)(40 + (formcount *= 2)) * this.antiscales[this.lineScales[n]]));
            this.lineCounter += 1.0f / (float)this.scaledLinesNumber[this.lineScales[n]];
            this.linespace = (int)((float)this.linespace + 5.0f * (44.0f / (float)this.scaledLinesNumber[this.lineScales[n]]));
            if (!(this.lineCounter <= 1.0f)) continue;
            ++this.numOfLines;
        }
        for (n = 0; n < 16; ++n) {
            this.chapters[n] = n % 2 == 0 ? new GuiBiblioTextField(this.field_146289_q, this.widthLocal + 224, this.heightLocal + 11 + 15 * n, 75, 8) : new GuiBiblioTextField(this.field_146289_q, this.widthLocal + 224, this.heightLocal + 21 + 15 * (n - 1), 75, 8);
            this.chapters[n].setEnableBackgroundDrawing(false);
            this.chapters[n].setMaxStringLength(15);
            this.chapters[n].setTextColor(0);
            if (this.chapterNames[n] == null) continue;
            this.chapters[n].setText(this.chapterNames[n]);
        }
        if (this.currentPage == 0) {
            this.buttonPageBack.field_146124_l = false;
            this.buttonPageFirst.field_146124_l = false;
        } else {
            this.buttonPageBack.field_146124_l = true;
            this.buttonPageFirst.field_146124_l = true;
        }
        this.buttonPageForward.field_146124_l = this.currentPage != 255;
        if (this.currentPage == this.totalPages - 1) {
            this.buttonPageLast.field_146124_l = false;
            if (this.signed) {
                this.buttonPageForward.field_146124_l = false;
            }
        } else {
            this.buttonPageLast.field_146124_l = true;
        }
        if (this.signing) {
            this.buttonPageBack.field_146124_l = false;
            this.buttonPageFirst.field_146124_l = false;
            this.buttonPageForward.field_146124_l = false;
            this.buttonPageLast.field_146124_l = false;
            this.buttonSignCancel = new GuiButton(2, this.widthLocal + 20, this.heightLocal + 204, 80, 20, StatCollector.func_74838_a((String)"book.cancel"));
            this.field_146292_n.add(this.buttonSignCancel);
            this.buttonSignAccept = new GuiButton(3, this.widthLocal + 120, this.heightLocal + 204, 80, 20, StatCollector.func_74838_a((String)"book.sign"));
            this.field_146292_n.add(this.buttonSignAccept);
            this.signTextField = new GuiBiblioTextField(this.field_146289_q, this.widthLocal + 22, this.heightLocal + 80, 180, 8);
            this.signTextField.setEnableBackgroundDrawing(false);
            this.signTextField.setMaxStringLength(34);
            this.signTextField.setTextColor(0);
        }
    }

    public void saveLinesToList() {
        this.lineTexts = new String[44];
        for (int n = 0; n < 44; ++n) {
            this.lineTexts[n] = this.lines[n].getText();
        }
    }

    public void func_73863_a(int x, int y, float f) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BIGBOOKGUI);
        this.func_73729_b(this.widthLocal, this.heightLocal, 0, 0, this.bookImageWidth, this.bookImageHeight);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.BIGBOOKGUIBUTTONS);
        if (!this.signing) {
            for (i = 0; i < 8; ++i) {
                if (this.chapterBool[i]) {
                    if (this.signed) {
                        this.func_73729_b(this.widthLocal + 212, this.heightLocal + 6 + this.spacing * i, 0, 171, 100, 28);
                    } else if (x > this.widthLocal + 299 && x < this.widthLocal + 311 && y > this.heightLocal + 16 + this.spacing * i && y < this.heightLocal + 21 + this.spacing * i) {
                        this.func_73729_b(this.widthLocal + 212, this.heightLocal + 6 + this.spacing * i, 0, 84, 100, 28);
                    } else {
                        this.func_73729_b(this.widthLocal + 212, this.heightLocal + 6 + this.spacing * i, 0, 55, 100, 28);
                    }
                    this.func_73729_b(this.widthLocal + 205, this.heightLocal + 15 + this.spacing * i, 62, 13, 17, 10);
                    if (this.currentPage == this.chapterPageNums[i]) {
                        this.func_73729_b(this.widthLocal + 205, this.heightLocal + 15 + this.spacing * i, 62, 35, 17, 10);
                    }
                    if (x <= this.widthLocal + 207 || x >= this.widthLocal + 221 || y <= this.heightLocal + 10 + this.spacing * i || y >= this.heightLocal + 29 + this.spacing * i) continue;
                    this.func_73729_b(this.widthLocal + 205, this.heightLocal + 15 + this.spacing * i, 62, 24, 17, 10);
                    continue;
                }
                if (this.signed) continue;
                if (x > this.widthLocal + 212 && x < this.widthLocal + 222 && y > this.heightLocal + 14 + this.spacing * i && y < this.heightLocal + 25 + this.spacing * i) {
                    this.func_73729_b(this.widthLocal + 212, this.heightLocal + 6 + this.spacing * i, 0, 142, 95, 28);
                    continue;
                }
                this.func_73729_b(this.widthLocal + 212, this.heightLocal + 6 + this.spacing * i, 0, 113, 16, 28);
            }
        }
        if (!this.signed && !this.signing) {
            this.func_73729_b(this.widthLocal - 60, this.heightLocal + 65, 0, 0, 60, 53);
            this.func_73729_b(this.widthLocal - 60, this.heightLocal + 137, 0, 200, 60, 54);
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (x <= this.widthLocal - 60 + j * 15 || x >= this.widthLocal - 45 + j * 15 || y <= this.heightLocal + 66 + i * 13 || y >= this.heightLocal + 79 + i * 13) continue;
                    this.func_73729_b(this.widthLocal - 59 + j * 15, this.heightLocal + 66 + i * 13, 62, 0, 13, 12);
                }
            }
        }
        if (!this.signing) {
            int n;
            if (this.buttonPageForward.field_146124_l) {
                if (x > this.widthLocal + 149 && x < this.widthLocal + 169 && y > this.heightLocal + 234 && y < this.heightLocal + 246) {
                    this.func_73729_b(this.widthLocal + 150, this.heightLocal + 235, 103, 0, 18, 10);
                } else {
                    this.func_73729_b(this.widthLocal + 150, this.heightLocal + 235, 80, 0, 18, 10);
                }
            }
            if (this.buttonPageBack.field_146124_l) {
                if (x > this.widthLocal + 44 && x < this.widthLocal + 64 && y > this.heightLocal + 234 && y < this.heightLocal + 246) {
                    this.func_73729_b(this.widthLocal + 45, this.heightLocal + 235, 103, 13, 18, 10);
                } else {
                    this.func_73729_b(this.widthLocal + 45, this.heightLocal + 235, 80, 13, 18, 10);
                }
            }
            if (this.buttonPageFirst.field_146124_l) {
                if (x > this.widthLocal + 14 && x < this.widthLocal + 32 && y > this.heightLocal + 234 && y < this.heightLocal + 246) {
                    this.func_73729_b(this.widthLocal + 15, this.heightLocal + 234, 80, 37, 18, 10);
                } else {
                    this.func_73729_b(this.widthLocal + 15, this.heightLocal + 234, 80, 26, 18, 10);
                }
            }
            if (this.buttonPageLast.field_146124_l) {
                if (x > this.widthLocal + 178 && x < this.widthLocal + 197 && y > this.heightLocal + 234 && y < this.heightLocal + 246) {
                    this.func_73729_b(this.widthLocal + 179, this.heightLocal + 234, 103, 37, 18, 10);
                } else {
                    this.func_73729_b(this.widthLocal + 179, this.heightLocal + 234, 103, 26, 18, 10);
                }
            }
            for (n = 0; n < this.numOfLines; ++n) {
                if (this.lines[n].getCursorPosition() > this.lines[n].getText().length()) {
                    this.lines[n].setCursorPosition(this.lines[n].getText().length() - 1);
                }
                if (this.lines[n].getMaxStringLength() < this.lines[n].getText().length()) {
                    this.lines[n].setText(this.lines[n].getText().substring(0, this.lines[n].getMaxStringLength()));
                }
                if (this.lines[n].getText().length() <= 0) continue;
                GL11.glScalef((float)this.scales[this.lineScales[n]], (float)this.scales[this.lineScales[n]], (float)this.scales[this.lineScales[n]]);
                this.lines[n].drawTextBox();
                GL11.glScalef((float)this.antiscales[this.lineScales[n]], (float)this.antiscales[this.lineScales[n]], (float)this.antiscales[this.lineScales[n]]);
            }
            int m = 0;
            for (n = 0; n < 16; ++n) {
                if (this.chapterBool[m]) {
                    this.chapters[n].drawTextBox();
                }
                if (n % 2 == 0) continue;
                ++m;
            }
        }
        super.func_73863_a(x, y, f);
        if (!this.signing && !this.signed) {
            this.func_73732_a(this.field_146289_q, this.textScale, this.widthLocal - 31, this.heightLocal + 142, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.textScaling[this.lineScales[this.currentLine]], this.widthLocal - 30, this.heightLocal + 160, 65280);
            this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"book.linenum"), this.widthLocal - 39, this.heightLocal + 178, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.currentLine + 1 + "", this.widthLocal - 10, this.heightLocal + 178, 65280);
        }
        if (!this.signing) {
            this.pagesTextLine = this.currentPage + 1 + "  of  " + this.totalPages;
            this.field_146289_q.func_85187_a(this.pagesTextLine, this.widthLocal + 103 - this.pagesTextLine.length() * 4 / 2, this.heightLocal + 237, 0, false);
        }
        if (this.signing) {
            this.signTextField.drawTextBox();
            this.field_146289_q.func_85187_a(this.signingInstruct, this.widthLocal + 22, this.heightLocal + 65, 0x616161, false);
            this.field_146289_q.func_78279_b(this.signingNotice, this.widthLocal + 22, this.heightLocal + 150, 180, 0x616161);
            this.field_146289_q.func_85187_a(this.signedBy, this.widthLocal + 100, this.heightLocal + 100, 0, false);
            this.field_146289_q.func_85187_a(this.signedAuthor, this.widthLocal + 102 - this.signedAuthor.length() * 5 / 2, this.heightLocal + 115, 0, false);
        }
    }

    protected void func_146284_a(GuiButton click) {
        switch (click.field_146127_k) {
            case 0: {
                this.saveCurrentPageToNBT();
                this.sendPacket();
                this.field_146297_k.field_71439_g.func_71053_j();
                break;
            }
            case 1: {
                this.signing = true;
                this.saveCurrentPageToNBT();
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                this.signTextField.setFocused(true);
                break;
            }
            case 2: {
                this.signing = false;
                this.signTextField.setFocused(false);
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.signed = true;
                this.signing = false;
                this.signTextField.setFocused(false);
                this.saveSigningToNBT();
                this.func_73866_w_();
                break;
            }
            case 10: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.BOLD + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 11: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.ITALIC + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 12: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.UNDERLINE + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 13: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.STRIKETHROUGH + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 14: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.OBFUSCATED + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 15: {
                String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), EnumChatFormatting.RESET + "");
                this.lines[this.currentLine].setText(moddedLine);
                break;
            }
            case 16: {
                if (this.lineScales[this.currentLine] < 7) {
                    int n = this.currentLine;
                    this.lineScales[n] = this.lineScales[n] + 1;
                    this.saveCurrentPageToNBT();
                    this.loadCurrentPageLinesFromNBT();
                    this.func_73866_w_();
                    break;
                }
                this.lineScales[this.currentLine] = 0;
                this.saveCurrentPageToNBT();
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                break;
            }
            case 17: {
                if (this.lineScales[this.currentLine] > 0) {
                    int n = this.currentLine;
                    this.lineScales[n] = this.lineScales[n] - 1;
                    this.saveCurrentPageToNBT();
                    this.loadCurrentPageLinesFromNBT();
                    this.func_73866_w_();
                    break;
                }
                this.lineScales[this.currentLine] = 7;
                this.saveCurrentPageToNBT();
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                break;
            }
            case 18: {
                if (this.currentPage <= 0) break;
                this.saveCurrentPageToNBT();
                --this.currentPage;
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                break;
            }
            case 19: {
                this.saveCurrentPageToNBT();
                ++this.currentPage;
                if (this.totalPages == this.currentPage) {
                    ++this.totalPages;
                }
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                break;
            }
            case 20: {
                this.saveCurrentPageToNBT();
                this.currentPage = 0;
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                break;
            }
            case 21: {
                this.saveCurrentPageToNBT();
                this.currentPage = this.totalPages - 1;
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
            }
        }
    }

    public String addTextMod(String line, String mod) {
        String partA = "";
        String partB = "";
        if (this.currentLineCursorPos > 0 && this.currentLineCursorPos <= line.length() && line.length() > 0) {
            partA = line.substring(0, this.currentLineCursorPos);
            partB = line.substring(this.currentLineCursorPos, line.length());
            return partA + mod + partB;
        }
        return mod + line;
    }

    public void sendPacket() {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.book);
        if (this.isinhand) {
            BiblioCraft.ch_BiblioClipboard.sendToServer(new FMLProxyPacket(buffer, "BiblioUpdateInv"));
        } else {
            buffer.writeInt(this.tilex);
            buffer.writeInt(this.tiley);
            buffer.writeInt(this.tilez);
            BiblioCraft.ch_BiblioMCBEdit.sendToServer(new FMLProxyPacket(buffer, "BiblioMCBEdit"));
        }
    }

    protected void func_73864_a(int x, int y, int par3) {
        int i;
        super.func_73864_a(x, y, par3);
        if (!this.signed && !this.signing) {
            int n;
            for (n = 0; n < this.numOfLines; ++n) {
                if (!this.lines[n].mouseClicked((int)((float)x * this.antiscales[this.lineScales[n]]), (int)((float)y * this.antiscales[this.lineScales[n]]), par3)) continue;
                this.currentLine = n;
                this.currentLineCursorPos = this.lines[n].getCursorPosition();
            }
            int m = 0;
            for (n = 0; n < 16; ++n) {
                if (!this.chapterBool[m] || this.chapters[n].mouseClicked(x, y, par3)) {
                    // empty if block
                }
                if (n % 2 == 0) continue;
                ++m;
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (x <= this.widthLocal - 60 + j * 15 || x >= this.widthLocal - 45 + j * 15 || y <= this.heightLocal + 66 + i * 13 || y >= this.heightLocal + 79 + i * 13) continue;
                    String moddedLine = this.addTextMod(this.lines[this.currentLine].getText(), this.mods[i][j]);
                    this.lines[this.currentLine].setText(moddedLine);
                }
            }
        }
        for (i = 0; i < 8; ++i) {
            if (this.chapterBool[i]) {
                if (x > this.widthLocal + 299 && x < this.widthLocal + 311 && y > this.heightLocal + 16 + this.spacing * i && y < this.heightLocal + 21 + this.spacing * i && !this.signed && !this.signing) {
                    this.chapterBool[i] = false;
                }
                if (x <= this.widthLocal + 207 || x >= this.widthLocal + 221 || y <= this.heightLocal + 10 + this.spacing * i || y >= this.heightLocal + 29 + this.spacing * i) continue;
                this.saveCurrentPageToNBT();
                this.currentPage = this.chapterPageNums[i];
                this.loadCurrentPageLinesFromNBT();
                this.func_73866_w_();
                continue;
            }
            if (x <= this.widthLocal + 212 || x >= this.widthLocal + 222 || y <= this.heightLocal + 14 + this.spacing * i || y >= this.heightLocal + 25 + this.spacing * i || this.signed || this.signing) continue;
            this.chapterBool[i] = true;
            this.chapterPageNums[i] = this.currentPage;
        }
    }

    protected void func_73869_a(char par1, int key) {
        if (key == 1) {
            NBTTagCompound tags = this.book.func_77978_p();
            if (tags != null) {
                this.saveCurrentPageToNBT();
                this.sendPacket();
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.signing) {
            this.signTextField.textboxKeyTyped(par1, key);
        }
        if (!this.signed && !this.signing) {
            int m;
            boolean isline;
            int n;
            for (n = 0; n < 44; ++n) {
                if (!this.lines[n].isFocused()) continue;
                this.lines[n].textboxKeyTyped(par1, key);
                String textTest = this.lines[n].getText();
                int formcount = 0;
                this.currentLineCursorPos = this.lines[n].getCursorPosition();
                if (textTest.length() > 0) {
                    for (int m2 = 0; m2 < textTest.length(); ++m2) {
                        if (!textTest.substring(m2, m2 + 1).contains("\u00a7")) continue;
                        ++formcount;
                    }
                }
                this.lines[n].setMaxStringLength((int)((float)(40 + (formcount *= 2)) * this.antiscales[this.lineScales[n]]));
            }
            for (n = 0; n < 16; ++n) {
                if (!this.chapters[n].isFocused()) continue;
                this.chapters[n].textboxKeyTyped(par1, key);
            }
            if (key == 203 || key == 14) {
                this.currentLineCursorPos = this.lines[this.currentLine].getCursorPosition();
                if (this.currentLineCursorPos == 0 && this.currentLine > 0) {
                    this.lines[this.currentLine].setFocused(false);
                    --this.currentLine;
                    this.lines[this.currentLine].setFocused(true);
                    this.currentLineCursorPos = this.lines[this.currentLine].getCursorPosition();
                }
            }
            if (key == 205) {
                this.currentLineCursorPos = this.lines[this.currentLine].getCursorPosition();
            }
            if (key == 200 && this.currentLine > 0) {
                isline = true;
                m = 0;
                for (int n2 = 0; n2 < 15; ++n2) {
                    if (this.chapterBool[m] && this.chapters[n2].isFocused()) {
                        isline = false;
                        if (n2 > 0) {
                            this.chapters[n2].setFocused(false);
                            this.chapters[n2 - 1].setFocused(true);
                            break;
                        }
                    }
                    if (n2 % 2 == 0) continue;
                    ++m;
                }
                if (isline) {
                    this.lines[this.currentLine].setFocused(false);
                    --this.currentLine;
                    this.lines[this.currentLine].setFocused(true);
                }
            }
            if ((key == 208 || key == 28) && this.currentLine < this.numOfLines - 1) {
                isline = true;
                m = 0;
                for (int n3 = 0; n3 < 15; ++n3) {
                    if (this.chapterBool[m] && this.chapters[n3].isFocused()) {
                        isline = false;
                        if (n3 < 15) {
                            this.chapters[n3].setFocused(false);
                            this.chapters[n3 + 1].setFocused(true);
                            break;
                        }
                    }
                    if (n3 % 2 == 0) continue;
                    ++m;
                }
                if (isline) {
                    this.lines[this.currentLine].setFocused(false);
                    ++this.currentLine;
                    this.lines[this.currentLine].setFocused(true);
                }
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

