/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import openeye.Log;
import openeye.notes.GuiMainMenuAddon;

public class NotesButtonInjector {
    public static void registerInjector() {
        try {
            Class.forName("net.minecraftforge.client.event.GuiScreenEvent");
            MinecraftForge.EVENT_BUS.register((Object)new EventBasedReplacer());
        }
        catch (ClassNotFoundException e) {
            Log.info("Old forge version, using fallback GUI modification method", new Object[0]);
            MinecraftForge.EVENT_BUS.register((Object)new FallbackReplacer());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class EventBasedReplacer {
        @SubscribeEvent
        public void onGuiInit(GuiScreenEvent.InitGuiEvent evt) {
            if (evt.gui instanceof GuiMainMenu) {
                GuiMainMenuAddon.onGuiInit(evt.gui, evt.buttonList);
            }
        }

        @SubscribeEvent
        public void onGuiInit(GuiScreenEvent.DrawScreenEvent.Post evt) {
            if (evt.gui instanceof GuiMainMenu) {
                GuiMainMenuAddon.onScreenDraw(evt.gui);
            }
        }

        @SubscribeEvent
        public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent evt) {
            if (evt.gui instanceof GuiMainMenu) {
                GuiMainMenuAddon.onActionPerformed(evt.gui.field_146297_k, evt.gui, evt.button);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class FallbackReplacer {
        @SubscribeEvent
        public void onGuiOpen(GuiOpenEvent evt) {
            if (evt.gui != null && evt.gui.getClass() == GuiMainMenu.class) {
                evt.gui = new GuiMainMenuAddon();
            }
        }
    }
}

