/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel;

import com.cricketcraft.chisel.utils.General;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class BlockNameConversion {
    private static final HashMap<String, String> namingConversion = new HashMap();

    public static void init() {
        namingConversion.put("blockCobble", "cobblestone");
        namingConversion.put("iron", "iron_block");
        namingConversion.put("gold", "gold_block");
        namingConversion.put("diamond", "diamond_block");
        namingConversion.put("lightstone", "glowstone");
        namingConversion.put("lapis", "lapis_block");
        namingConversion.put("emerald", "emerald_block");
        namingConversion.put("hellrock", "netherrack");
        namingConversion.put("stoneMoss", "mossy_cobblestone");
        namingConversion.put("stoneBrick", "stonebrick");
        namingConversion.put("fenceIron", "iron_bars");
        namingConversion.put("fantasy", "fantasyblock");
        namingConversion.put("carpetFloor", "carpet");
        namingConversion.put("temple", "templeblock");
        namingConversion.put("templeMossy", "mossy_templeblock");
        namingConversion.put("factory", "factoryblock");
        namingConversion.put("laboratory", "laboratoryblock");
        namingConversion.put("stainedGlassLightGray", "stained_glass_lightgray");
        namingConversion.put("stainedGlassPaneLightGray", "stained_glass_pane_lightgray");
        namingConversion.put("blockTemple", "templeblock");
        namingConversion.put("stoneBrick", "stonebricksmooth");
        namingConversion.put("blockTempleMossy", "mossy_templeblock");
        namingConversion.put("blockFactory", "factoryblock");
        namingConversion.put("blockFft", "fantasyblock");
        namingConversion.put("blockCarpetFloor", "carpet");
        namingConversion.put("blockLaboratory", "laboratoryblock");
    }

    public static Item findItem(String oldname) {
        FMLLog.getLogger().trace("[Chisel 2] findItem() START " + oldname);
        Item item = null;
        for (int i = 0; i < 5 && item == null; ++i) {
            FMLLog.getLogger().trace("[Chisel 2] findItem()       Checking for " + NameConversions.conversion(oldname, i));
            item = GameRegistry.findItem((String)"chisel", (String)NameConversions.conversion(oldname, i));
        }
        return item;
    }

    public static Block findBlock(String oldname) {
        FMLLog.getLogger().trace("[Chisel 2] findBlock() START: " + oldname);
        Block block = null;
        for (int i = 0; i < 5 && block == null; ++i) {
            FMLLog.getLogger().trace("[Chisel 2] findBlock()       Checking for " + NameConversions.conversion(oldname, i));
            block = GameRegistry.findBlock((String)"chisel", (String)NameConversions.conversion(oldname, i));
        }
        return block;
    }

    public static class NameConversions {
        public static final int MAX = 5;

        protected static String conversion(String oldname, int step) {
            oldname = General.cleanTags(oldname);
            String newname = null;
            switch (step) {
                case 0: {
                    return (String)namingConversion.get(oldname);
                }
                case 1: {
                    if (oldname.startsWith("Chisel:")) {
                        newname = oldname.replaceAll("(?i)Chisel:", "");
                    }
                    return newname;
                }
                case 2: {
                    newname = oldname.replaceAll("([a-z]+)([A-Z])", "$1_$2").toLowerCase();
                    if (newname.startsWith("block_")) {
                        newname = newname.replaceFirst("block_([a-z_]+)", "$1_block");
                    } else if (newname.startsWith("snakestone_")) {
                        newname = newname.replaceFirst("snakestone_([a-z_]+)", "$1_snakestone");
                    }
                    return newname;
                }
                case 3: {
                    newname = oldname.replaceAll("([a-z]+)([A-Z])", "$1_$2").toLowerCase().replace('-', '_');
                    if (newname.contains("wood_")) {
                        newname = newname.replaceFirst("wood_([a-z_]+)", "$1_planks");
                    }
                    return newname;
                }
                case 4: {
                    return oldname.replaceAll("([a-z]+)([A-Z])", "$1_$2").toLowerCase().replaceFirst("block_", "");
                }
            }
            throw new IndexOutOfBoundsException("conversion got invalid parameter step=" + step);
        }
    }
}

