/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import cpw.mods.fml.common.eventhandler.Event;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.asm.Hooks;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;
import squeek.asmhelper.ObfHelper;

public class ModuleFoodStats
implements IClassTransformerModule {
    public static String foodStatsPlayerField = "entityplayer";

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.player.EntityPlayer", "net.minecraft.util.FoodStats"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!ASMHelper.isCauldron() && transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            boolean isObfuscated = !name.equals(transformedName);
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "<init>", null);
            if (methodNode != null) {
                this.patchEntityPlayerInit(methodNode, isObfuscated);
                return ASMHelper.writeClassToBytes(classNode);
            }
            throw new RuntimeException("EntityPlayer: <init> method not found");
        }
        if (transformedName.equals("net.minecraft.util.FoodStats")) {
            MethodNode addStatsMethodNode;
            boolean isObfuscated = !name.equals(transformedName);
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            if (!ASMHelper.isCauldron()) {
                this.injectFoodStatsPlayerField(classNode);
                this.injectFoodStatsConstructor(classNode, isObfuscated);
            }
            if ((addStatsMethodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "addStats", "(IF)V")) == null) {
                throw new RuntimeException("FoodStats: addStats(IF)V method not found");
            }
            this.hookFoodStatsAddition(classNode, addStatsMethodNode, isObfuscated);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "func_151686_a", isObfuscated ? "(Lacx;Ladd;)V" : "(Lnet/minecraft/item/ItemFood;Lnet/minecraft/item/ItemStack;)V");
            if (methodNode == null) {
                throw new RuntimeException("FoodStats: ItemStack-aware addStats method not found");
            }
            this.addItemStackAwareFoodStatsHook(classNode, methodNode, isObfuscated);
            MethodNode updateMethodNode = ASMHelper.findMethodNodeOfClass(classNode, isObfuscated ? "a" : "onUpdate", isObfuscated ? "(Lyz;)V" : "(Lnet/minecraft/entity/player/EntityPlayer;)V");
            if (updateMethodNode == null) {
                throw new RuntimeException("FoodStats: onUpdate method not found");
            }
            this.hookHealthRegen(classNode, updateMethodNode, isObfuscated);
            this.hookExhaustion(classNode, updateMethodNode, isObfuscated);
            this.hookStarvation(classNode, updateMethodNode, isObfuscated);
            return ASMHelper.writeClassToBytes(classNode);
        }
        return basicClass;
    }

    public void patchEntityPlayerInit(MethodNode method, boolean isObfuscated) {
        AbstractInsnNode targetNode = ASMHelper.find(method.instructions, (AbstractInsnNode)new TypeInsnNode(187, isObfuscated ? "zr" : "net/minecraft/util/FoodStats"));
        if (targetNode == null) {
            throw new RuntimeException("patchEntityPlayerInit: NEW instruction not found");
        }
        while ((targetNode = targetNode.getNext()) != null && targetNode.getOpcode() != 183) {
        }
        if (targetNode == null) {
            throw new RuntimeException("patchEntityPlayerInit: INVOKESPECIAL instruction not found");
        }
        method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
        ((MethodInsnNode)targetNode).desc = isObfuscated ? "(Lyz;)V" : "(Lnet/minecraft/entity/player/EntityPlayer;)V";
    }

    public void injectFoodStatsPlayerField(ClassNode classNode) {
        classNode.fields.add(new FieldNode(1, foodStatsPlayerField, ObfHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer"), null, null));
    }

    public void injectFoodStatsConstructor(ClassNode classNode, boolean isObfuscated) {
        MethodNode defaultConstructor = ASMHelper.findMethodNodeOfClass(classNode, "<init>", "()V");
        MethodNode constructor = new MethodNode(1, "<init>", isObfuscated ? "(Lyz;)V" : "(Lnet/minecraft/entity/player/EntityPlayer;)V", null, null);
        constructor.instructions = ASMHelper.cloneInsnList(defaultConstructor.instructions);
        AbstractInsnNode targetNode = ASMHelper.findLastInstructionWithOpcode(constructor, 177);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, foodStatsPlayerField, ObfHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer")));
        constructor.instructions.insertBefore(targetNode, toInject);
        classNode.methods.add(constructor);
    }

    public void addItemStackAwareFoodStatsHook(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        String internalFoodStatsName = classNode.name.replace(".", "/");
        InsnList toInject = new InsnList();
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        LabelNode modifiedFoodValuesStart = new LabelNode();
        LabelNode end = ASMHelper.findEndLabel(method);
        LocalVariableNode modifiedFoodValues = new LocalVariableNode("modifiedFoodValues", ObfHelper.getDescriptor("net.minecraft.util.FoodStats"), null, modifiedFoodValuesStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(modifiedFoodValues);
        LabelNode prevFoodLevelStart = new LabelNode();
        LocalVariableNode prevFoodLevel = new LocalVariableNode("prevFoodLevel", "I", null, prevFoodLevelStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevFoodLevel);
        LabelNode prevSaturationLevelStart = new LabelNode();
        LocalVariableNode prevSaturationLevel = new LocalVariableNode("prevSaturationLevel", "F", null, prevSaturationLevelStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevSaturationLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, foodStatsPlayerField, ObfHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onFoodStatsAdded", "(Lnet/minecraft/util/FoodStats;Lnet/minecraft/item/ItemFood;Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;)Lsqueek/applecore/api/food/FoodValues;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)modifiedFoodValuesStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)prevFoodLevelStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)prevSaturationLevelStart);
        method.instructions.insertBefore(targetNode, toInject);
        InsnList hungerNeedle = new InsnList();
        hungerNeedle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        hungerNeedle.add((AbstractInsnNode)new VarInsnNode(25, 2));
        hungerNeedle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemFood"), isObfuscated ? "g" : "func_150905_g", "(" + ObfHelper.getDescriptor("net.minecraft.item.ItemStack") + ")I"));
        InsnList hungerReplacement = new InsnList();
        hungerReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        hungerReplacement.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(FoodValues.class), "hunger", "I"));
        InsnList saturationNeedle = new InsnList();
        saturationNeedle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        saturationNeedle.add((AbstractInsnNode)new VarInsnNode(25, 2));
        saturationNeedle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemFood"), isObfuscated ? "h" : "func_150906_h", "(" + ObfHelper.getDescriptor("net.minecraft.item.ItemStack") + ")F"));
        InsnList saturationReplacement = new InsnList();
        saturationReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        saturationReplacement.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(FoodValues.class), "saturationModifier", "F"));
        ASMHelper.findAndReplaceAll(method.instructions, hungerNeedle, hungerReplacement);
        ASMHelper.findAndReplaceAll(method.instructions, saturationNeedle, saturationReplacement);
        targetNode = ASMHelper.findLastInstructionWithOpcode(method, 177);
        toInject.clear();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)new InsnNode(100));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)new InsnNode(102));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, foodStatsPlayerField, ObfHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "onPostFoodStatsAdded", "(Lnet/minecraft/util/FoodStats;Lnet/minecraft/item/ItemFood;Lnet/minecraft/item/ItemStack;Lsqueek/applecore/api/food/FoodValues;IFLnet/minecraft/entity/player/EntityPlayer;)V"));
        method.instructions.insertBefore(targetNode, toInject);
    }

    private void hookFoodStatsAddition(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        LabelNode ifCanceled = new LabelNode();
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name.replace(".", "/"), foodStatsPlayerField, ObfHelper.getDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(FoodValues.class)));
        toInject.add((AbstractInsnNode)new InsnNode(89));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, 2));
        toInject.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(FoodValues.class), "<init>", "(IF)V"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireFoodStatsAdditionEvent", "(Lnet/minecraft/entity/player/EntityPlayer;Lsqueek/applecore/api/food/FoodValues;)Z"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, ifCanceled));
        method.instructions.insertBefore(targetNode, toInject);
        targetNode = ASMHelper.findLastInstructionWithOpcode(method, 177);
        method.instructions.insertBefore(targetNode, (AbstractInsnNode)ifCanceled);
    }

    private void hookExhaustion(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        String internalFoodStatsName = classNode.name.replace(".", "/");
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        InsnList toInject = new InsnList();
        AbstractInsnNode injectPoint = ASMHelper.findFirstInstructionWithOpcode(method, 181);
        AbstractInsnNode foodExhaustionIf = ASMHelper.findFirstInstructionWithOpcode(method, 158);
        LabelNode foodExhaustionBlockEndLabel = ((JumpInsnNode)foodExhaustionIf).label;
        ASMHelper.removeFromInsnListUntil(method.instructions, injectPoint.getNext(), (AbstractInsnNode)foodExhaustionBlockEndLabel);
        LabelNode allowExhaustionResultStart = new LabelNode();
        LocalVariableNode allowExhaustionResult = new LocalVariableNode("allowExhaustionResult", Type.getDescriptor(Event.Result.class), null, allowExhaustionResultStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowExhaustionResult);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireAllowExhaustionEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowExhaustionResult.index));
        toInject.add((AbstractInsnNode)allowExhaustionResultStart);
        LabelNode maxExhaustionStart = new LabelNode();
        LocalVariableNode maxExhaustion = new LocalVariableNode("maxExhaustion", "F", null, maxExhaustionStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(maxExhaustion);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "c" : "foodExhaustionLevel", "F"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireExhaustionTickEvent", "(Lnet/minecraft/entity/player/EntityPlayer;F)F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, maxExhaustion.index));
        toInject.add((AbstractInsnNode)maxExhaustionStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowExhaustionResult.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "ALLOW", Type.getDescriptor(Event.Result.class)));
        LabelNode ifAllowed = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowed));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowExhaustionResult.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "DEFAULT", Type.getDescriptor(Event.Result.class)));
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, foodExhaustionBlockEndLabel));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "c" : "foodExhaustionLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, maxExhaustion.index));
        toInject.add((AbstractInsnNode)new InsnNode(149));
        toInject.add((AbstractInsnNode)new JumpInsnNode(155, foodExhaustionBlockEndLabel));
        toInject.add((AbstractInsnNode)ifAllowed);
        LabelNode exhaustedEventStart = new LabelNode();
        LocalVariableNode exhaustedEvent = new LocalVariableNode("exhaustionMaxEvent", Type.getDescriptor(ExhaustionEvent.Exhausted.class), null, exhaustedEventStart, foodExhaustionBlockEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(exhaustedEvent);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, maxExhaustion.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "c" : "foodExhaustionLevel", "F"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireExhaustionMaxEvent", "(Lnet/minecraft/entity/player/EntityPlayer;FF)Lsqueek/applecore/api/hunger/ExhaustionEvent$Exhausted;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, exhaustedEvent.index));
        toInject.add((AbstractInsnNode)exhaustedEventStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(89));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "c" : "foodExhaustionLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, exhaustedEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(ExhaustionEvent.Exhausted.class), "deltaExhaustion", "F"));
        toInject.add((AbstractInsnNode)new InsnNode(98));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "c" : "foodExhaustionLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, exhaustedEvent.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(ExhaustionEvent.Exhausted.class), "isCanceled", "()Z"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, foodExhaustionBlockEndLabel));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, exhaustedEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(ExhaustionEvent.Exhausted.class), "deltaSaturation", "F"));
        toInject.add((AbstractInsnNode)new InsnNode(98));
        toInject.add((AbstractInsnNode)new InsnNode(11));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Math", "max", "(FF)F"));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, exhaustedEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(ExhaustionEvent.Exhausted.class), "deltaHunger", "I"));
        toInject.add((AbstractInsnNode)new InsnNode(96));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Math", "max", "(II)I"));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        method.instructions.insert(injectPoint, toInject);
    }

    private void hookHealthRegen(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        String internalFoodStatsName = classNode.name.replace(".", "/");
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        InsnList toInject = new InsnList();
        AbstractInsnNode entryPoint = ASMHelper.find(method.instructions, (AbstractInsnNode)new LdcInsnNode((Object)"naturalRegeneration"));
        AbstractInsnNode injectPoint = entryPoint.getPrevious().getPrevious().getPrevious().getPrevious();
        AbstractInsnNode healthBlockJumpToEnd = ASMHelper.findNextInstructionWithOpcode(entryPoint, 167);
        LabelNode healthBlockEndLabel = ((JumpInsnNode)healthBlockJumpToEnd).label;
        ASMHelper.removeFromInsnListUntil(method.instructions, injectPoint.getNext(), (AbstractInsnNode)healthBlockEndLabel);
        LabelNode allowRegenResultStart = new LabelNode();
        LocalVariableNode allowRegenResult = new LocalVariableNode("allowRegenResult", Type.getDescriptor(Event.Result.class), null, allowRegenResultStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowRegenResult);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireAllowRegenEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowRegenResult.index));
        toInject.add((AbstractInsnNode)allowRegenResultStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowRegenResult.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "ALLOW", Type.getDescriptor(Event.Result.class)));
        LabelNode ifAllowed = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowed));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowRegenResult.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "DEFAULT", Type.getDescriptor(Event.Result.class)));
        LabelNode elseStart = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, elseStart));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "o" : "worldObj", isObfuscated ? "Lahb;" : "Lnet/minecraft/world/World;"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.world.World"), isObfuscated ? "O" : "getGameRules", isObfuscated ? "()Lagy;" : "()Lnet/minecraft/world/GameRules;"));
        toInject.add((AbstractInsnNode)new LdcInsnNode((Object)"naturalRegeneration"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.world.GameRules"), isObfuscated ? "b" : "getGameRuleBooleanValue", "(Ljava/lang/String;)Z"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, elseStart));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new IntInsnNode(16, 18));
        toInject.add((AbstractInsnNode)new JumpInsnNode(161, elseStart));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "bR" : "shouldHeal", "()Z"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, elseStart));
        toInject.add((AbstractInsnNode)ifAllowed);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(89));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "d" : "foodTimer", "I"));
        toInject.add((AbstractInsnNode)new InsnNode(4));
        toInject.add((AbstractInsnNode)new InsnNode(96));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "d" : "foodTimer", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "d" : "foodTimer", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireRegenTickEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)I"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(161, healthBlockEndLabel));
        LabelNode regenEventStart = new LabelNode();
        LabelNode regenEventEnd = new LabelNode();
        LocalVariableNode regenEvent = new LocalVariableNode("regenEvent", Type.getDescriptor(HealthRegenEvent.Regen.class), null, regenEventStart, regenEventEnd, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(regenEvent);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireRegenEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)Lsqueek/applecore/api/hunger/HealthRegenEvent$Regen;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, regenEvent.index));
        toInject.add((AbstractInsnNode)regenEventStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, regenEvent.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(HealthRegenEvent.Regen.class), "isCanceled", "()Z"));
        LabelNode ifCanceled = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, ifCanceled));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, regenEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(HealthRegenEvent.Regen.class), "deltaHealth", "F"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.EntityLivingBase"), isObfuscated ? "f" : "heal", "(F)V"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, regenEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(HealthRegenEvent.Regen.class), "deltaExhaustion", "F"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, internalFoodStatsName, isObfuscated ? "a" : "addExhaustion", "(F)V"));
        toInject.add((AbstractInsnNode)ifCanceled);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "d" : "foodTimer", "I"));
        toInject.add((AbstractInsnNode)regenEventEnd);
        toInject.add((AbstractInsnNode)new JumpInsnNode(167, healthBlockEndLabel));
        toInject.add((AbstractInsnNode)elseStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, isObfuscated ? "d" : "foodTimer", "I"));
        method.instructions.insert(injectPoint, toInject);
    }

    private void hookStarvation(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        classNode.fields.add(new FieldNode(1, "starveTimer", "I", null, null));
        String internalFoodStatsName = classNode.name.replace(".", "/");
        AbstractInsnNode lastReturn = ASMHelper.findLastInstructionWithOpcode(method, 177);
        InsnList toInject = new InsnList();
        LabelNode allowStarvationResultStart = new LabelNode();
        LabelNode beforeReturn = new LabelNode();
        LocalVariableNode allowStarvationResult = new LocalVariableNode("allowStarvationResult", "Lcpw/mods/fml/common/eventhandler/Event$Result;", null, allowStarvationResultStart, beforeReturn, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowStarvationResult);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireAllowStarvation", "(Lnet/minecraft/entity/player/EntityPlayer;)Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowStarvationResult.index));
        toInject.add((AbstractInsnNode)allowStarvationResultStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowStarvationResult.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "ALLOW", Type.getDescriptor(Event.Result.class)));
        LabelNode ifAllowed = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowed));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, allowStarvationResult.index));
        LabelNode elseStart = new LabelNode();
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(Event.Result.class), "DEFAULT", Type.getDescriptor(Event.Result.class)));
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, elseStart));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, isObfuscated ? "a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(157, elseStart));
        toInject.add((AbstractInsnNode)ifAllowed);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(89));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, "starveTimer", "I"));
        toInject.add((AbstractInsnNode)new InsnNode(4));
        toInject.add((AbstractInsnNode)new InsnNode(96));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, "starveTimer", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, "starveTimer", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireStarvationTickEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)I"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(161, beforeReturn));
        LabelNode starveEventStart = new LabelNode();
        LabelNode starveEventEnd = new LabelNode();
        LocalVariableNode starveEvent = new LocalVariableNode("starveEvent", Type.getDescriptor(StarvationEvent.Starve.class), null, starveEventStart, starveEventEnd, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(starveEvent);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Hooks.class), "fireStarveEvent", "(Lnet/minecraft/entity/player/EntityPlayer;)Lsqueek/applecore/api/hunger/StarvationEvent$Starve;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, starveEvent.index));
        toInject.add((AbstractInsnNode)starveEventStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, starveEvent.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(StarvationEvent.Starve.class), "isCanceled", "()Z"));
        LabelNode ifCanceled = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, ifCanceled));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, ObfHelper.getInternalClassName("net.minecraft.util.DamageSource"), isObfuscated ? "field_76366_f" : "starve", isObfuscated ? "Lro;" : "Lnet/minecraft/util/DamageSource;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, starveEvent.index));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(StarvationEvent.Starve.class), "starveDamage", "F"));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), isObfuscated ? "a" : "attackEntityFrom", isObfuscated ? "(Lro;F)Z" : "(Lnet/minecraft/util/DamageSource;F)Z"));
        toInject.add((AbstractInsnNode)new InsnNode(87));
        toInject.add((AbstractInsnNode)ifCanceled);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, "starveTimer", "I"));
        toInject.add((AbstractInsnNode)starveEventEnd);
        toInject.add((AbstractInsnNode)new JumpInsnNode(167, beforeReturn));
        toInject.add((AbstractInsnNode)elseStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, internalFoodStatsName, "starveTimer", "I"));
        toInject.add((AbstractInsnNode)beforeReturn);
        method.instructions.insertBefore(lastReturn, toInject);
    }
}

