/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.ItemBattery;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBatteryChargeHotbar
extends ItemBattery {
    private static final byte MAX_MODE = 1;

    public ItemBatteryChargeHotbar(InternalName internalName, double maxCharge, double transferLimit, int tier) {
        super(internalName, maxCharge, transferLimit, tier);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        list.add(this.getNameOfMode(this.getMode(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldObj, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayerMP && worldObj.func_82737_E() % 10L == (long)this.getTier(stack) && this.getMode(stack) == 0) {
            EntityPlayer thePlayer = (EntityPlayer)entity;
            ItemStack[] inventory = thePlayer.field_71071_by.field_70462_a;
            double limit = this.getTransferLimit(stack);
            int tier = this.getTier(stack);
            for (int i = 0; i < 9; ++i) {
                ItemStack toCharge = inventory[i];
                if (toCharge == null || !(toCharge.func_77973_b() instanceof IElectricItem) || toCharge.func_77973_b() instanceof ItemBatteryChargeHotbar) continue;
                double charge = ElectricItem.manager.charge(toCharge, limit, tier, false, true);
                charge = ElectricItem.manager.discharge(stack, charge, tier, true, false, false);
                ElectricItem.manager.charge(toCharge, charge, tier, true, false);
                if ((limit -= charge) <= 0.0) break;
            }
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (world.field_72995_K) {
            return itemStack;
        }
        byte mode = this.getMode(itemStack);
        if (mode == 1) {
            mode = 0;
            this.setMode(itemStack, (byte)0);
        } else {
            mode = (byte)(mode + 1);
            this.setMode(itemStack, mode);
        }
        IC2.platform.messagePlayer(entityplayer, StatCollector.func_74837_a((String)"ic2.tooltip.mode", (Object[])new Object[]{this.getNameOfMode(mode)}), new Object[0]);
        return itemStack;
    }

    private String getNameOfMode(byte mode) {
        switch (mode) {
            case 0: {
                return StatCollector.func_74838_a((String)"addServer.resourcePack.enabled");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"addServer.resourcePack.disabled");
            }
        }
        return "ERROR!";
    }

    public void setMode(ItemStack stack, byte mode) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74774_a("mode", mode);
    }

    public byte getMode(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        if (!nbt.func_74764_b("mode")) {
            return 0;
        }
        return nbt.func_74771_c("mode");
    }
}

