/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.util.LogCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private static final List<TileEntityComponent> emptyComponents = Arrays.asList(new Object[0]);
    private static final List<Map.Entry<String, TileEntityComponent>> emptyNamedComponents = Arrays.asList(new Object[0]);
    private Map<String, TileEntityComponent> components;
    private List<TileEntityComponent> updatableComponents;
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    private boolean loaded = false;
    private boolean enableWorldTick;
    private static final Map<Class<?>, TickSubscription> tickSubscriptions = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private IIcon[] lastRenderIcons;
    private int tesrMask;
    public int tesrTtl;
    private static final int defaultTesrTtl = 500;

    public final void func_145829_t() {
        super.func_145829_t();
        IC2.tickHandler.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityBlock.this.func_145837_r() || !world.func_72899_e(TileEntityBlock.this.field_145851_c, TileEntityBlock.this.field_145848_d, TileEntityBlock.this.field_145849_e)) {
                    return;
                }
                TileEntityBlock.this.onLoaded();
                if (!TileEntityBlock.this.func_145837_r() && (TileEntityBlock.this.enableWorldTick || TileEntityBlock.this.updatableComponents != null)) {
                    world.field_147482_g.add(TileEntityBlock.this);
                }
            }
        });
    }

    public final void func_145843_s() {
        this.onUnloaded();
        super.func_145843_s();
    }

    public final void onChunkUnload() {
        this.onUnloaded();
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.loaded = true;
        this.enableWorldTick = this.requiresWorldTick();
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onLoaded();
                if (!component.enableWorldTick()) continue;
                if (this.updatableComponents == null) {
                    this.updatableComponents = new ArrayList<TileEntityComponent>(4);
                }
                this.updatableComponents.add(component);
            }
        }
    }

    public void onUnloaded() {
        if (!this.loaded) {
            return;
        }
        this.loaded = false;
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onUnloaded();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.prevFacing = this.facing = nbt.func_74765_d("facing");
        this.prevActive = this.active = nbt.func_74767_n("active");
        if (this.components != null && nbt.func_150297_b("components", 10)) {
            NBTTagCompound componentsNbt = nbt.func_74775_l("components");
            for (String name : componentsNbt.func_150296_c()) {
                NBTTagCompound componentNbt = componentsNbt.func_74775_l(name);
                TileEntityComponent component = this.components.get(name);
                if (component == null) {
                    IC2.log.warn(LogCategory.Block, "Can't find component {} while loading {}.", name, this);
                    continue;
                }
                component.readFromNbt(componentNbt);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("facing", this.facing);
        nbt.func_74757_a("active", this.active);
        NBTTagCompound componentsNbt = null;
        if (this.components != null) {
            for (Map.Entry<String, TileEntityComponent> entry : this.components.entrySet()) {
                NBTTagCompound componentNbt = entry.getValue().writeToNbt();
                if (componentNbt == null) continue;
                if (componentsNbt == null) {
                    componentsNbt = new NBTTagCompound();
                    nbt.func_74782_a("components", (NBTBase)componentsNbt);
                }
                componentsNbt.func_74782_a(entry.getKey(), (NBTBase)componentNbt);
            }
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public final void func_145845_h() {
        if (this.updatableComponents != null) {
            for (TileEntityComponent component : this.updatableComponents) {
                component.onWorldTick();
            }
        }
        if (this.enableWorldTick) {
            if (this.field_145850_b.field_72995_K) {
                this.updateEntityClient();
            } else {
                this.updateEntityServer();
            }
        }
    }

    protected void updateEntityClient() {
    }

    protected void updateEntityServer() {
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender() {
        Block block = this.func_145838_q();
        if (this.lastRenderIcons == null) {
            this.lastRenderIcons = new IIcon[6];
        }
        for (int side = 0; side < 6; ++side) {
            this.lastRenderIcons[side] = block.func_149673_e((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
        }
        this.tesrMask = 0;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active1) {
        this.active = active1;
        if (this.prevActive != active1) {
            IC2.network.get().updateTileEntityField(this, "active");
        }
        this.prevActive = active1;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int reRenderMask = 0;
            Block block = this.func_145838_q();
            if (this.lastRenderIcons == null) {
                reRenderMask = -1;
            } else {
                for (int side = 0; side < 6; ++side) {
                    IIcon newIcon;
                    IIcon oldIcon = this.lastRenderIcons[side];
                    if (oldIcon instanceof BlockTextureStitched) {
                        oldIcon = ((BlockTextureStitched)oldIcon).getRealTexture();
                    }
                    if ((newIcon = block.func_149673_e((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side)) instanceof BlockTextureStitched) {
                        newIcon = ((BlockTextureStitched)newIcon).getRealTexture();
                    }
                    if (oldIcon == newIcon) continue;
                    reRenderMask |= 1 << side;
                }
            }
            if (reRenderMask != 0) {
                if (reRenderMask < 0 || this.prevFacing != this.facing || block.func_149645_b() != IC2.platform.getRenderId("default")) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else {
                    this.tesrMask = reRenderMask;
                    this.tesrTtl = 500;
                }
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing1) {
        this.facing = facing1;
        if (this.prevFacing != facing1) {
            IC2.network.get().updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing1;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public boolean shouldRenderInPass(int pass) {
        return this.tesrMask != 0 && pass == 0;
    }

    public final int getTesrMask() {
        return this.tesrMask;
    }

    public void onBlockBreak(Block block, int meta) {
    }

    public String getTextureFolder() {
        return null;
    }

    public boolean onBlockActivated(EntityPlayer player, float xOffset, float yOffset, float zOffset, MutableBoolean result) {
        return false;
    }

    public void randomDisplayTick(Random random) {
    }

    public void adjustDrops(List<ItemStack> drops, int fortune) {
    }

    protected final <T extends TileEntityComponent> T addComponent(T component) {
        return this.addComponent(component.getDefaultName(), component);
    }

    protected final <T extends TileEntityComponent> T addComponent(String name, T component) {
        TileEntityComponent prev;
        if (this.components == null) {
            this.components = new HashMap<String, TileEntityComponent>(4);
        }
        if ((prev = this.components.put(name, component)) != null) {
            throw new RuntimeException("ambiguous component name " + name + " when adding " + component + ", already used by " + prev + ".");
        }
        return component;
    }

    public TileEntityComponent getComponent(String name) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(name);
    }

    public final Iterable<TileEntityComponent> getComponents() {
        if (this.components == null) {
            return emptyComponents;
        }
        return this.components.values();
    }

    public final Iterable<Map.Entry<String, TileEntityComponent>> getNamedComponents() {
        if (this.components == null) {
            return emptyNamedComponents;
        }
        return this.components.entrySet();
    }

    public void onNeighborUpdate(Block srcBlock) {
        if (this.components != null) {
            for (TileEntityComponent component : this.components.values()) {
                component.onNeighborUpdate(srcBlock);
            }
        }
    }

    private final boolean requiresWorldTick() {
        Class<?> cls = this.getClass();
        TickSubscription subscription = tickSubscriptions.get(cls);
        if (subscription == null) {
            boolean hasUpdateClient = false;
            boolean hasUpdateServer = false;
            while (!(cls == TileEntityBlock.class || hasUpdateClient && hasUpdateServer)) {
                boolean found;
                if (!hasUpdateClient) {
                    found = true;
                    try {
                        cls.getDeclaredMethod("updateEntityClient", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        found = false;
                    }
                    if (found) {
                        hasUpdateClient = true;
                    }
                }
                if (!hasUpdateServer) {
                    found = true;
                    try {
                        cls.getDeclaredMethod("updateEntityServer", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        found = false;
                    }
                    if (found) {
                        hasUpdateServer = true;
                    }
                }
                cls = cls.getSuperclass();
            }
            subscription = hasUpdateClient ? (hasUpdateServer ? TickSubscription.Both : TickSubscription.Client) : (hasUpdateServer ? TickSubscription.Server : TickSubscription.None);
            tickSubscriptions.put(this.getClass(), subscription);
        }
        if (this.field_145850_b.field_72995_K) {
            return subscription == TickSubscription.Both || subscription == TickSubscription.Client;
        }
        return subscription == TickSubscription.Both || subscription == TickSubscription.Server;
    }

    private static enum TickSubscription {
        None,
        Client,
        Server,
        Both;

    }
}

