/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.util.AbstractJSONConfig;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import java.util.Map;
import java.util.PriorityQueue;

@SideOnly(value=Side.CLIENT)
public class ExtTileTextureConfig
extends AbstractJSONConfig<ExtTileTextureMap> {
    private static final int VERSION = 1;
    private final TextureSetMap textureSetMap;

    public ExtTileTextureConfig(File file, TextureSetMap textureSetMap) {
        super(file);
        this.textureSetMap = textureSetMap;
    }

    @Override
    public int currentVersion() {
        return 1;
    }

    @Override
    protected void loadData(JsonObject json, ExtTileTextureMap data, int version) {
        for (Map.Entry entry : json.entrySet()) {
            String tileName = (String)entry.getKey();
            String textureName = ((JsonElement)entry.getValue()).getAsString();
            if (this.textureSetMap.isRegistered(textureName)) {
                data.setTexture(tileName, this.textureSetMap.getByName(textureName));
                Log.info("Registered texture set %s for tile \"%s\"", textureName, tileName);
                continue;
            }
            Log.warn("Unknown texture set %s for tile \"%s\"", textureName, tileName);
        }
    }

    @Override
    protected void saveData(JsonObject json, ExtTileTextureMap data) {
        PriorityQueue<String> queue = new PriorityQueue<String>(data.textureMap.keySet());
        while (!queue.isEmpty()) {
            String tileName = (String)queue.poll();
            json.addProperty(tileName, data.textureMap.get((Object)tileName).name);
        }
    }
}

