/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.ITileStorage;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.Rect;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DimensionData
implements ITileStorage {
    public final AtlasData parent;
    public final int dimension;
    private int browsingX;
    private int browsingY;
    private double browsingZoom = 0.5;
    private final Map<ShortVec2, Tile> tiles = new ConcurrentHashMap<ShortVec2, Tile>(2, 0.75f, 2);
    private final Map<Thread, ShortVec2> thread2KeyMap = new ConcurrentHashMap<Thread, ShortVec2>(2, 0.75f, 2);
    private final Rect scope = new Rect();

    public DimensionData(AtlasData parent, int dimension) {
        this.parent = parent;
        this.dimension = dimension;
    }

    public Map<ShortVec2, Tile> getSeenChunks() {
        return this.tiles;
    }

    public void setBrowsingPosition(int x, int y, double zoom) {
        this.browsingX = x;
        this.browsingY = y;
        this.browsingZoom = zoom;
        if (this.browsingZoom <= 0.0) {
            Log.warn("Setting map zoom to invalid value of %f", zoom);
            this.browsingZoom = AntiqueAtlasMod.settings.minScale;
        }
        this.parent.func_76185_a();
    }

    public int getBrowsingX() {
        return this.browsingX;
    }

    public int getBrowsingY() {
        return this.browsingY;
    }

    public double getBrowsingZoom() {
        return this.browsingZoom;
    }

    private ShortVec2 getKey() {
        ShortVec2 key = this.thread2KeyMap.get(Thread.currentThread());
        if (key == null) {
            key = new ShortVec2(0, 0);
            this.thread2KeyMap.put(Thread.currentThread(), key);
        }
        return key;
    }

    @Override
    public void setTile(int x, int y, Tile tile) {
        this.tiles.put(new ShortVec2(x, y), tile);
        this.scope.extendTo(x, y);
        this.parent.func_76185_a();
    }

    @Override
    public Tile removeTile(int x, int y) {
        Tile oldTile = this.tiles.remove(this.getKey().set(x, y));
        if (oldTile != null) {
            this.parent.func_76185_a();
        }
        return oldTile;
    }

    @Override
    public Tile getTile(int x, int y) {
        return this.tiles.get(this.getKey().set(x, y));
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.tiles.containsKey(this.getKey().set(x, y));
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public DimensionData clone() {
        DimensionData data = new DimensionData(this.parent, this.dimension);
        data.tiles.putAll(this.tiles);
        data.scope.set(this.scope);
        return data;
    }
}

