/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.util.AbstractJSONConfig;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class BiomeTextureConfig
extends AbstractJSONConfig<BiomeTextureMap> {
    private static final int VERSION = 1;
    private final TextureSetMap textureSetMap;

    public BiomeTextureConfig(File file, TextureSetMap textureSetMap) {
        super(file);
        this.textureSetMap = textureSetMap;
    }

    @Override
    public int currentVersion() {
        return 1;
    }

    @Override
    protected void loadData(JsonObject json, BiomeTextureMap data, int version) {
        if (version == 0) {
            Log.warn("Too many biome textures changed since config version 0, disregarding this config entirely", new Object[0]);
            return;
        }
        for (Map.Entry entry : json.entrySet()) {
            int biomeID = Integer.parseInt((String)entry.getKey());
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                ResourceLocation[] textures = new ResourceLocation[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    String path = array.get(i).getAsString();
                    textures[i] = new ResourceLocation(path);
                }
                data.setTexture(biomeID, new TextureSet(null, textures));
                Log.info("Registered %d custom texture(s) for biome %d", textures.length, biomeID);
                continue;
            }
            String name = ((JsonElement)entry.getValue()).getAsString();
            if (this.textureSetMap.isRegistered(name)) {
                data.setTexture(biomeID, this.textureSetMap.getByName(name));
                Log.info("Registered texture set %s for biome %d", name, biomeID);
                continue;
            }
            Log.warn("Unknown texture set %s for biome %d", name, biomeID);
        }
    }

    @Override
    protected void saveData(JsonObject json, BiomeTextureMap data) {
        PriorityQueue<Integer> queue = new PriorityQueue<Integer>(data.textureMap.keySet());
        while (!queue.isEmpty()) {
            int biomeID = (Integer)queue.poll();
            if (biomeID < 0 || biomeID >= 256) continue;
            json.addProperty(String.valueOf(biomeID), data.textureMap.get((Object)Integer.valueOf((int)biomeID)).name);
        }
    }
}

