/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import ZombieAwareness.CommandZA;
import ZombieAwareness.CommonProxy;
import ZombieAwareness.ZAEventHandler;
import ZombieAwareness.ZAEventHandlerFML;
import ZombieAwareness.ZAUtil;
import ZombieAwareness.config.ZAConfig;
import ZombieAwareness.config.ZAConfigFeatures;
import ZombieAwareness.config.ZAConfigPlayerLists;
import ZombieAwareness.config.ZAConfigSpawning;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="ZAMod", name="Zombie Awareness", version="v1.9.5")
public class ZombieAwareness
implements IPFCallback {
    @Mod.Instance(value="ZAMod")
    public static ZombieAwareness instance;
    public static String modID;
    public static MinecraftServer mc;
    public static World worldRef;
    public static EntityPlayer player;
    public static boolean ingui;
    public static boolean openChat;
    public static long lastWorldTime;
    public static boolean tryTropicraft;
    public static int lastZombieCount;
    public static long lastSpawnTime;
    public static long lastSpawnSysTime;
    public Configuration preInitConfig;
    @SidedProxy(clientSide="ZombieAwareness.ClientProxy", serverSide="ZombieAwareness.CommonProxy")
    public static CommonProxy proxy;
    public static int timeout;
    public static String msg;
    public static int color;
    public static int defaultColor;
    public static boolean keyDownLastTick;
    public static boolean heldItemLastTick;
    public static boolean toggle;
    public ArrayList<PFCallbackItem> callbackList = new ArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ZAConfigFeatures configMain = new ZAConfigFeatures();
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"zaconfig", (IConfigCategory)new ZAConfig());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"zaconfigfeatures", (IConfigCategory)configMain);
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"zaconfigplayerlists", (IConfigCategory)new ZAConfigPlayerLists());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"zaconfigspawning", (IConfigCategory)new ZAConfigSpawning());
        configMain.hookUpdatedValues();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ZAEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new ZAEventHandlerFML());
        proxy.init(this);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ((ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)new CommandZA());
    }

    public ZombieAwareness() {
        boolean hm = false;
    }

    public void onTick(MinecraftServer var1) {
        this.onTickInGame(var1);
    }

    public void onTickInGame(MinecraftServer var1) {
        mc = var1;
        World worldTemp = worldRef;
        if (worldTemp != null) {
            worldTemp = mc.func_71218_a(0);
            if (worldTemp != null) {
                this.worldTick(worldTemp);
            }
        } else {
            worldRef = mc.func_71218_a(0);
        }
        ingui = false;
    }

    public void worldTick(World world) {
        if (!world.field_72995_K) {
            this.manageCallbackQueue();
            int lastCount = 0;
            boolean spawned = false;
            Random rand = new Random();
            if (lastSpawnTime - 1000L > world.func_72820_D()) {
                lastSpawnTime = 0L;
            }
            if (world.func_72820_D() % (long)ZAConfig.tickRateAILoop == 0L) {
                List ents = world.field_72996_f;
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Block id;
                    EntityPlayer closestPlayer;
                    Entity ent = (Entity)world.field_72996_f.get(i);
                    if (!(ent instanceof EntityMob) || ent instanceof ICoroAI || !(ZAConfigPlayerLists.blacklistUsedAITick && (EntityList.func_75621_b((Entity)ent) == null || !ZAConfigPlayerLists.forceListUsedAITickAsWhitelist && !ZAConfigPlayerLists.blacklistAITick.toLowerCase().contains(EntityList.func_75621_b((Entity)ent).toLowerCase()) || ZAConfigPlayerLists.forceListUsedAITickAsWhitelist && ZAConfigPlayerLists.blacklistAITick.toLowerCase().contains(EntityList.func_75621_b((Entity)ent).toLowerCase()))) && (ZAConfigPlayerLists.blacklistUsedAITick || ent instanceof EntityEnderman || ent instanceof EntityWolf || ent instanceof EntityCreeper || ent instanceof EntityPigZombie)) continue;
                    ZAUtil.aiTick((EntityLiving)ent);
                    if (((EntityLiving)ent).func_70661_as().func_75500_f() || !ent.field_70122_E || ent.field_70123_F) {
                        // empty if block
                    }
                    if (world.field_73011_w.field_76574_g != 0 || !(ent instanceof EntityZombie)) continue;
                    ++lastCount;
                    if (lastSpawnTime >= ent.field_70170_p.func_72820_D() || spawned || ent.field_70170_p.func_72890_a(ent, 32.0) != null || rand.nextInt(ZAConfigSpawning.maxZombiesNightBaseRarity + lastZombieCount * 4 / Math.max(1, ZAConfig.tickRateAILoop)) != 0) continue;
                    if (!ent.field_70170_p.func_72935_r() && lastZombieCount < ZAConfigSpawning.maxZombiesNight && ent.field_70170_p.func_72937_j((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) && ent.field_70170_p.func_72957_l((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) < 5) {
                        EntityZombie entZ = new EntityZombie(ent.field_70170_p);
                        entZ.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                        ent.field_70170_p.func_72838_d((Entity)entZ);
                        spawned = true;
                        lastSpawnTime = (long)ZAConfigSpawning.zombieSpawnTickDelay + ent.field_70170_p.func_72820_D();
                        lastSpawnSysTime = System.currentTimeMillis();
                        if (!ZAConfig.debugConsoleSpawns) continue;
                        ZombieAwareness.dbg("Spawned new surface zombie at: " + ent.field_70165_t + ", " + ent.field_70163_u + ", " + ent.field_70161_v);
                        continue;
                    }
                    if (!ZAConfigFeatures.extraSpawningCave || lastZombieCount >= ZAConfigSpawning.extraSpawningMaxCount || (closestPlayer = ent.field_70170_p.func_72856_b(ent, (double)ZAConfigSpawning.extraSpawningDistMax)) == null || ZAConfigPlayerLists.whiteListUsedExtraSpawning && !ZAConfigPlayerLists.whitelistExtraSpawning.contains(CoroUtilEntity.getName((Entity)closestPlayer)) || !(closestPlayer.func_70068_e(ent) > (double)ZAConfigSpawning.extraSpawningDistMin) || ent.field_70170_p.func_72937_j((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) || ent.field_70170_p.func_72957_l((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v) >= 5 || CoroUtilBlock.isAir((Block)(id = ent.field_70170_p.func_147439_a((int)ent.field_70165_t, (int)(ent.field_70121_D.field_72338_b - 0.5), (int)ent.field_70161_v))) || id == Blocks.field_150349_c) continue;
                    EntityZombie entZ = new EntityZombie(ent.field_70170_p);
                    entZ.func_70107_b(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                    ent.field_70170_p.func_72838_d((Entity)entZ);
                    if (ZAConfigSpawning.extraSpawningAutoTarget) {
                        entZ.func_70624_b((EntityLivingBase)closestPlayer);
                    }
                    spawned = true;
                    lastSpawnTime = (long)ZAConfigSpawning.zombieSpawnTickDelay + ent.field_70170_p.func_72820_D();
                    lastSpawnSysTime = System.currentTimeMillis();
                    if (!ZAConfig.debugConsoleSpawns) continue;
                    ZombieAwareness.dbg("Spawned new cave zombie at: " + ent.field_70165_t + ", " + ent.field_70163_u + ", " + ent.field_70161_v);
                }
                if (world.field_73011_w.field_76574_g == 0) {
                    lastZombieCount = lastCount;
                }
            }
        }
        if (world.func_72820_D() % (long)ZAConfig.tickRatePlayerLoop == 0L) {
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
                if (player == null) continue;
                ZAUtil.playerTick(player);
            }
        }
    }

    public static void displayMessage(String var0, int var1) {
        msg = var0;
        timeout = 85;
        color = var1;
    }

    public static void displayMessage(String var0) {
        ZombieAwareness.displayMessage(var0, defaultColor);
    }

    public synchronized void pfComplete(PFCallbackItem ci) {
        this.callbackList.add(ci);
    }

    public void manageCallbackQueue() {
        ArrayList<PFCallbackItem> list = this.getQueue();
        try {
            for (int i = 0; i < list.size(); ++i) {
                PFCallbackItem item = list.get(i);
                if (item.ent.field_70128_L || !OldUtil.chunkExists((World)item.ent.field_70170_p, (int)((int)item.ent.field_70165_t / 16), (int)((int)item.ent.field_70161_v / 16))) continue;
                item.ent.func_70661_as().func_75484_a(item.pe, (double)item.speed);
            }
        }
        catch (Exception ex) {
            System.out.println("Crash in ZA Callback Item manager");
            ex.printStackTrace();
        }
        list.clear();
    }

    public ArrayList<PFCallbackItem> getQueue() {
        return this.callbackList;
    }

    public static void dbg(Object obj) {
        if (ZAConfig.debugConsole) {
            System.out.println(obj);
        }
    }

    static {
        modID = "zombieawareness";
        openChat = false;
        tryTropicraft = true;
        defaultColor = 0xFFFFFF;
        keyDownLastTick = false;
        heldItemLastTick = false;
        toggle = false;
    }
}

