/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import CoroUtil.OldUtil;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import ZombieAwareness.EntityScent;
import ZombieAwareness.ZombieAwareness;
import ZombieAwareness.config.ZAConfig;
import ZombieAwareness.config.ZAConfigFeatures;
import ZombieAwareness.config.ZAConfigPlayerLists;
import ZombieAwareness.config.ZAConfigSpawning;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ZAUtil {
    public static long traceCount = 0L;
    public static long lastSoundTime;
    public static float lastMultiply;
    public static Random rand;
    public static HashMap<String, Integer> lastHealths;
    public static HashMap<String, Long> lastBleedTimes;
    public static boolean debug;

    public static void playerTick(EntityPlayer player) {
        if (ZAConfigFeatures.wanderingHordes && rand.nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((Entity)player);
        }
        if (ZombieAwareness.lastZombieCount < ZAConfigSpawning.extraSpawningMaxCount && !ZAConfigPlayerLists.whiteListUsedExtraSpawning || ZAConfigPlayerLists.whitelistExtraSpawning.contains(CoroUtilEntity.getName((Entity)player))) {
            if (ZAConfigFeatures.extraSpawningSurface && !player.field_70170_p.func_72935_r() && rand.nextInt(Math.max(1, ZAConfigSpawning.extraSpawningRandomPool)) == 0) {
                ZAUtil.spawnNewMobSurface((EntityLivingBase)player);
            }
            if (ZAConfigFeatures.extraSpawningCave) {
                // empty if block
            }
        }
        int lastHealth = lastHealths.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastHealths.get(CoroUtilEntity.getName((Entity)player)) : 0;
        Long lastBleedTime = lastBleedTimes.containsKey(CoroUtilEntity.getName((Entity)player)) ? lastBleedTimes.get(CoroUtilEntity.getName((Entity)player)) : 0L;
        if ((int)player.func_110143_aJ() != lastHealth) {
            if (player.func_110143_aJ() < (float)lastHealth) {
                ZAUtil.spawnScent((Entity)player);
            }
            lastHealth = (int)player.func_110143_aJ();
        }
        lastHealths.put(CoroUtilEntity.getName((Entity)player), lastHealth);
        if (player.func_110143_aJ() / player.func_110138_aP() < 0.6f && lastBleedTime < System.currentTimeMillis()) {
            lastBleedTime = System.currentTimeMillis() + 30000L;
            lastBleedTimes.put(CoroUtilEntity.getName((Entity)player), lastBleedTime);
            ZAUtil.spawnScent((Entity)player);
        }
    }

    public static void moveHelper(EntityLiving ent) {
        if (ZAConfig.zombieRandSpeedBoost > 0 && ent instanceof EntityZombie && !EntityList.func_75621_b((Entity)ent).contains("BrainyZombie")) {
            float moveSpeed = OldUtil.getMoveSpeed((EntityLivingBase)ent);
            if (moveSpeed == 0.23f) {
                float newSpeed = moveSpeed + (float)ent.field_70170_p.field_73012_v.nextInt(ZAConfig.zombieRandSpeedBoost) / 70.0f;
            }
            ent.func_70661_as().func_75489_a((double)moveSpeed);
        }
        if (ent.func_70090_H()) {
            ent.field_70181_x += 0.03;
            if (ent.func_70661_as().func_75505_d() != null) {
                Vec3 var1;
                block11: {
                    PathEntity pEnt = ent.func_70661_as().func_75505_d();
                    int index = pEnt.func_75873_e() + 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > pEnt.func_75874_d()) {
                        index = pEnt.func_75874_d() - 1;
                    }
                    var1 = null;
                    try {
                        var1 = pEnt.func_75881_a((Entity)ent, pEnt.func_75873_e());
                    }
                    catch (Exception ex) {
                        if (pEnt.func_75874_d() <= 0) break block11;
                        var1 = pEnt.func_75881_a((Entity)ent, pEnt.func_75874_d() - 1);
                    }
                }
                if (var1 != null) {
                    ent.func_70605_aq().func_75642_a(var1.field_72450_a, var1.field_72448_b, var1.field_72449_c, (double)0.53f);
                    double dist = ent.func_70011_f(var1.field_72450_a, var1.field_72448_b, var1.field_72449_c);
                    if (dist < 8.0) {
                        // empty if block
                    }
                    if (dist < 2.0) {
                        ent.func_70661_as().func_75505_d().func_75875_a();
                    }
                }
            }
        }
    }

    public static void huntTarget(EntityLivingBase ent, EntityLivingBase targ, int pri) {
        PFQueue.getPath((Entity)ent, (Entity)targ, (float)ZAConfig.maxPFRange, (int)pri, (IPFCallback)ZombieAwareness.instance);
        if (ent instanceof EntityLiving) {
            ((EntityLiving)ent).func_70624_b(targ);
        }
    }

    public static void huntTarget(EntityLivingBase ent, EntityLivingBase targ) {
        ZAUtil.huntTarget(ent, targ, 0);
    }

    public static boolean isEnemy(Entity ent, Entity targ) {
        return ZAUtil.isEnemy(ent, targ, false);
    }

    public static boolean isEnemy(Entity ent, Entity targ, boolean omniTarget) {
        if (targ instanceof EntityLivingBase) {
            if (targ instanceof EntityPlayer && !((EntityPlayer)targ).field_71075_bZ.field_75098_d) {
                if (!omniTarget) {
                    return true;
                }
                if (ZAConfigPlayerLists.whiteListUsedOmnipotent) {
                    if (ZAConfigPlayerLists.whitelistOmnipotentTargettedPlayers.contains(CoroUtilEntity.getName((Entity)((EntityPlayer)targ)))) {
                        if (ZAConfig.debugConsoleOmnipotent) {
                            ZombieAwareness.dbg(CoroUtilEntity.getName((Entity)((EntityPlayer)targ)) + " targetting omnipotently by " + ent);
                        }
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean sanityCheck(Entity ent, Entity entity1) {
        return true;
    }

    public static void aiTick(EntityLiving ent) {
        if (ZAConfig.debugConsoleSuperDetailed) {
            ZombieAwareness.dbg("ZA DBG: Ticking: " + ent);
        }
        if (ent.field_70170_p.func_72820_D() % 40L == 0L) {
            if (ZAConfig.omnipotent && ent.func_70638_az() == null) {
                ZAUtil.ai_FindTarget(ent, true);
            } else {
                ZAUtil.ai_FindTarget(ent, false);
            }
        }
        if (PFQueue.instance == null) {
            new PFQueue((IBlockAccess)ent.field_70170_p);
        }
        long time = 0L;
        try {
            if (PFQueue.pfDelays.containsKey(ent)) {
                time = (Long)PFQueue.pfDelays.get(ent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ent.func_70638_az() == null && time < System.currentTimeMillis() && ent.func_70661_as().func_75500_f()) {
            if (!ZAConfig.awareness_Light_OnlyZombies || ent instanceof EntityZombie) {
                if (!(ZAConfigFeatures.awareness_Light && ZAUtil.ai_FindLightSource((EntityLivingBase)ent) || ent.field_70170_p.field_73012_v.nextInt(3) != 0)) {
                    ZAUtil.ai_FindSense((EntityLivingBase)ent, true);
                }
            } else if (ZAUtil.ai_FindSense((EntityLivingBase)ent)) {
                // empty if block
            }
        }
        ZAUtil.customMobTick((EntityLivingBase)ent);
    }

    public static void customMobTick(EntityLivingBase ent) {
        if (ent instanceof EntitySpider && ent.field_70153_n != null && ent.field_70153_n instanceof EntitySkeleton && ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            ZAUtil.spawnWaypoint((Entity)ent);
        }
    }

    public static void setAge(EntityLivingBase ent, int age) {
        try {
            OldUtil.setPrivateValueBoth(EntityLivingBase.class, (Object)ent, (String)"field_70708_bq", (String)"entityAge", (Object)age);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean ai_FindLightSource(EntityLivingBase ent) {
        if (ent.field_70170_p.func_72935_r()) {
            return false;
        }
        if (ent.field_70170_p.field_73012_v.nextInt(1) == 0) {
            Random rand = new Random();
            int size = 32;
            for (int i = 0; i < 4; ++i) {
                EntityPlayer entP = ZAUtil.getClosestPlayerToEntity(ent.field_70170_p, (Entity)ent, 999.0);
                if (entP == null) continue;
                size = 32 * (i + 1);
                int rX = (int)entP.field_70165_t + (rand.nextInt(size) - size / 2);
                int rY = (int)entP.field_70163_u + (rand.nextInt(size / 2) - size / 4);
                int rZ = (int)entP.field_70161_v + (rand.nextInt(size) - size / 2);
                int lightValue = entP.field_70170_p.func_72957_l(rX, rY, rZ);
                Block id = ent.field_70170_p.func_147439_a(rX, rY, rZ);
                if (lightValue <= 4 || !(ent.func_70032_d((Entity)entP) > 64.0f && ent.field_70170_p.field_73012_v.nextInt(20) == 0) && ent.field_70170_p.func_72933_a(Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + (double)ent.func_70047_e()), (double)ent.field_70161_v), Vec3.func_72443_a((double)rX, (double)rY, (double)rZ)) != null) continue;
                if (PFQueue.getPath((Entity)ent, (int)rX, (int)rY, (int)rZ, (float)128.0f, (int)0, (IPFCallback)ZombieAwareness.instance) && debug) {
                    System.out.println("pathing to lightsource");
                }
                return true;
            }
        }
        return false;
    }

    public static boolean ai_FindSense(EntityLivingBase ent) {
        return ZAUtil.ai_FindSense(ent, true);
    }

    public static boolean ai_FindSense(EntityLivingBase ent, boolean includeWaypoints) {
        Entity var3 = ZAUtil.getScent((Entity)ent);
        if (var3 != null && (includeWaypoints || ((EntityScent)var3).type != 2)) {
            int curAge = ent.func_70654_ax();
            PFQueue.getPath((Entity)ent, (Entity)var3, (float)64.0f, (int)0, (IPFCallback)ZombieAwareness.instance);
            return true;
        }
        return false;
    }

    public static boolean ai_FindTarget(EntityLiving ent, boolean omnipotent) {
        long huntRange = ZAConfig.sightRange;
        if (omnipotent) {
            huntRange = 512L;
        }
        if (ent.func_70638_az() == null || ent.field_70170_p.field_73012_v.nextInt(100) == 0) {
            boolean found = false;
            Entity clEnt = null;
            float closest = 9999.0f;
            List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.field_70121_D.func_72314_b((double)huntRange, (double)(huntRange / 2L), (double)huntRange));
            for (int j = 0; j < list.size(); ++j) {
                float dist;
                Entity entity1 = (Entity)list.get(j);
                if (!ZAUtil.isEnemy((Entity)ent, entity1, omnipotent) || !omnipotent && !ZAConfig.seeThroughWalls && !((EntityLivingBase)entity1).func_70685_l((Entity)ent) || !ZAUtil.sanityCheck((Entity)ent, entity1) || !((dist = ent.func_70032_d(entity1)) < closest)) continue;
                closest = dist;
                clEnt = entity1;
            }
            if (clEnt != null) {
                ZAUtil.huntTarget((EntityLivingBase)ent, (EntityLivingBase)clEnt);
                return true;
            }
        }
        return false;
    }

    public static Entity getScent(Entity var0) {
        List var1 = var0.field_70170_p.func_72839_b(var0, var0.field_70121_D.func_72314_b((double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense, (double)ZAConfig.maxPFRangeSense));
        Entity var2 = null;
        Entity var3 = null;
        Object var4 = null;
        float var5 = 90000.0f;
        float var6 = 90000.0f;
        boolean var7 = false;
        for (int var8 = 0; var8 < var1.size(); ++var8) {
            var2 = (Entity)var1.get(var8);
            if (!(var2 instanceof EntityScent) || !(var0.func_70032_d(var2) < ((EntityScent)var2).getRange()) || !(var0.func_70032_d(var2) > 5.0f) || var0.field_70170_p.field_73012_v.nextInt(20) != 0) continue;
            var3 = var2;
        }
        return var3;
    }

    public static void soundHook(String var0, World world, float var1, float var2, float var3, float var4, float var5) {
        if (world.field_72995_K || var0 == null) {
            return;
        }
        if (world.field_73011_w.field_76574_g != 0 && world.field_73011_w.field_76574_g != -127) {
            return;
        }
        if (var0.contains("pop")) {
            // empty if block
        }
        if (!ZAConfigFeatures.awareness_Sound) {
            return;
        }
        if (!ZAUtil.canSpawnTrace(world, (int)var1, (int)var2, (int)var3)) {
            return;
        }
        EntityPlayer var6 = ZAUtil.getClosestPlayer(world, var1, var2, var3, 3.0);
        int var7 = (int)(20.0f * var4);
        boolean var8 = false;
        try {
            if (var0.substring(7).equals("bow") || var0.substring(7).equals("pop") || var0.substring(7).equals("wood")) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        if ((var8 || var6 != null) && var7 > 15) {
            EntityScent var9 = new EntityScent(world);
            if (!ZAUtil.canSpawnScentHere(world, Vec3.func_72443_a((double)var1, (double)var2, (double)var3))) {
                return;
            }
            if (var7 < 25) {
                var9.setStrength(ZAConfig.soundStrength);
            }
            var7 = var9.strength;
            if (var0.substring(7).equals("drr")) {
                var7 += 10;
            }
            if (lastSoundTime + (long)ZAConfig.frequentSoundThreshold > System.currentTimeMillis()) {
                var7 = (int)((float)var7 * (lastMultiply += 0.1f));
            } else {
                lastMultiply = 1.0f;
            }
            lastSoundTime = System.currentTimeMillis();
            var9.setStrength(var7);
            var9.type = 1;
            var9.func_70107_b(var1, var2, var3);
            world.func_72838_d((Entity)var9);
        } else {
            EntityPlayer farPlayer = ZAUtil.getClosestPlayer(world, var1, var2, var3, 128.0);
            if (farPlayer != null) {
                if (var0.substring(7).equals("bow") || var0.substring(7).equals("pop") || var0.substring(7).equals("wood")) {
                    return;
                }
                if (ZAConfigFeatures.noisyZombies && var0.contains("zombie.say")) {
                    if (rand.nextInt(1 + ZombieAwareness.lastZombieCount * 8) == 0) {
                        EntityScent es = ZAUtil.spawnSoundSense(world, var1, var2, var3, 80);
                    }
                } else if (ZAConfigFeatures.noisyPistons && var0.contains("piston") && rand.nextInt(40) == 0) {
                    EntityScent es = ZAUtil.spawnSoundSense(world, var1, var2, var3, 100);
                }
            }
        }
    }

    public static void blockEvent(PlayerEvent event, int chance) {
        if (event.entity.field_70170_p.field_73011_w.field_76574_g != 0 && event.entity.field_70170_p.field_73011_w.field_76574_g != -127) {
            return;
        }
        if (event.entityPlayer == null || ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)event.entityPlayer))) {
            return;
        }
        if (!event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.field_73012_v.nextInt(chance) == 0) {
            EntityScent var9 = new EntityScent(event.entity.field_70170_p);
            if (!ZAUtil.canSpawnScentHere(event.entity.field_70170_p, Vec3.func_72443_a((double)event.entityPlayer.field_70165_t, (double)event.entityPlayer.field_70163_u, (double)event.entityPlayer.field_70161_v))) {
                return;
            }
            var9.setStrength(ZAConfig.soundStrength);
            int var7 = var9.strength;
            if (lastSoundTime + (long)ZAConfig.frequentSoundThreshold > System.currentTimeMillis()) {
                var7 = (int)((float)var7 * (lastMultiply += 0.1f));
            } else {
                lastMultiply = 1.0f;
            }
            lastSoundTime = System.currentTimeMillis();
            var9.setStrength(var7);
            var9.type = 1;
            var9.func_70107_b(event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u, event.entityPlayer.field_70161_v);
            event.entity.field_70170_p.func_72838_d((Entity)var9);
        }
    }

    public static EntityScent spawnSoundSense(World world, float x, float y, float z, int strength) {
        EntityScent var9 = new EntityScent(world);
        var9.setStrength(strength);
        var9.type = 1;
        int size = ZAConfig.soundScentSpawnPosRandom;
        int randX = var9.field_70170_p.field_73012_v.nextInt(size);
        int randZ = var9.field_70170_p.field_73012_v.nextInt(size);
        var9.func_70107_b((double)x + (double)(-(size / 2) + randX), y, (double)z + (double)(-(size / 2) + randZ));
        if (!ZAUtil.canSpawnScentHere(world, Vec3.func_72443_a((double)((double)x + (double)(-(size / 2) + randX)), (double)y, (double)((double)z + (double)(-(size / 2) + randZ))))) {
            return null;
        }
        world.func_72838_d((Entity)var9);
        return var9;
    }

    public static void spawnScent(Entity var0) {
        if (!ZAConfigFeatures.awareness_Scent) {
            return;
        }
        if (!ZAUtil.canSpawnTrace(var0.field_70170_p, (int)var0.field_70165_t, (int)var0.field_70163_u, (int)var0.field_70161_v)) {
            return;
        }
        double height = var0.field_70163_u - (double)var0.field_70129_M + 0.0;
        EntityScent var1 = new EntityScent(var0.field_70170_p);
        if (!ZAUtil.canSpawnScentHere(var0.field_70170_p, Vec3.func_72443_a((double)var0.field_70165_t, (double)height, (double)var0.field_70161_v))) {
            return;
        }
        var1.func_70107_b(var0.field_70165_t, height, var0.field_70161_v);
        var1.setStrength(ZAConfig.scentStrength);
        var1.type = 0;
        var0.field_70170_p.func_72838_d((Entity)var1);
    }

    public static void spawnNewMobSurface(EntityLivingBase var0) {
        int range = 256;
        int minDist = ZAConfigSpawning.extraSpawningDistMin;
        int maxDist = ZAConfigSpawning.extraSpawningDistMax;
        for (int tries = 0; tries < 5; ++tries) {
            int tryZ;
            int tryY;
            int tryX = (int)var0.field_70165_t - range / 2 + rand.nextInt(range);
            if (var0.func_70011_f((double)tryX, (double)(tryY = var0.field_70170_p.func_72976_f(tryX, tryZ = (int)var0.field_70161_v - range / 2 + rand.nextInt(range))), (double)tryZ) < (double)minDist || var0.func_70011_f((double)tryX, (double)tryY, (double)tryZ) > (double)maxDist || !ZAUtil.canSpawnMob(var0.field_70170_p, tryX, tryY, tryZ) || var0.field_70170_p.func_72957_l(tryX, tryY, tryZ) >= 6) continue;
            EntityZombie entZ = new EntityZombie(var0.field_70170_p);
            entZ.func_70107_b((double)tryX, (double)tryY, (double)tryZ);
            var0.field_70170_p.func_72838_d((Entity)entZ);
            if (ZAConfigSpawning.extraSpawningAutoTarget) {
                entZ.func_70624_b(var0);
            }
            if (ZAConfig.debugConsoleSpawns) {
                ZombieAwareness.dbg("spawnNewMobSurface: " + tryX + ", " + tryY + ", " + tryZ);
            }
            return;
        }
    }

    public static void spawnNewMobCave(Entity var0) {
        int range = 256;
        for (int tries = 0; tries < 5; ++tries) {
            int tryZ;
            int tryY;
            int tryX = (int)var0.field_70165_t - range / 2 + rand.nextInt(range);
            if (!ZAUtil.canSpawnTrace(var0.field_70170_p, tryX, tryY = var0.field_70170_p.func_72976_f(tryX, tryZ = (int)var0.field_70161_v - range / 2 + rand.nextInt(range)), tryZ)) continue;
            EntityZombie entZ = new EntityZombie(var0.field_70170_p);
            entZ.func_70107_b(var0.field_70165_t, var0.field_70163_u, var0.field_70161_v);
            var0.field_70170_p.func_72838_d((Entity)entZ);
            if (ZAConfig.debugConsoleSpawns) {
                ZombieAwareness.dbg("spawnNewMobCave: " + var0.field_70165_t + ", " + var0.field_70163_u + ", " + var0.field_70161_v);
            }
            return;
        }
    }

    public static boolean canSpawnMob(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x - 1, y, z);
        return CoroUtilBlock.isAir((Block)id) || id.func_149688_o() != Material.field_151584_j;
    }

    public static void spawnWaypoint(Entity var0) {
        int tryZ;
        int tryY;
        if (!ZAConfigFeatures.awareness_Scent) {
            return;
        }
        int range = 256;
        int tryX = (int)var0.field_70165_t - range / 2 + rand.nextInt(range);
        if (!ZAUtil.canSpawnTrace(var0.field_70170_p, tryX, tryY = var0.field_70170_p.func_72976_f(tryX, tryZ = (int)var0.field_70161_v - range / 2 + rand.nextInt(range)), tryZ)) {
            return;
        }
        double height = var0.field_70163_u - (double)var0.field_70129_M + 0.0;
        EntityScent var1 = new EntityScent(var0.field_70170_p);
        if (!ZAUtil.canSpawnScentHere(var0.field_70170_p, Vec3.func_72443_a((double)tryX, (double)tryY, (double)tryZ))) {
            return;
        }
        var1.func_70107_b(tryX, tryY, tryZ);
        var1.setStrength(60);
        var1.type = 2;
        var0.field_70170_p.func_72838_d((Entity)var1);
        if (debug) {
            System.out.println("WP: " + var0 + " - range: " + var1.getRange());
        }
    }

    public static boolean canSpawnTrace(World world, int x, int y, int z) {
        return world.func_147439_a(x - 1, y, z).func_149688_o() != Material.field_151594_q;
    }

    public static Vec3 findLitBlock(EntityLivingBase ent, int yOffset, float factor, boolean noYaw) {
        try {
            EntityLivingBase entityliving = ent;
            boolean foundLit = false;
            Vec3 foundVec = null;
            for (int tryPhase = 1; tryPhase < 5 && !foundLit; ++tryPhase) {
                float f = factor * (float)tryPhase;
                float lookdist = factor * (float)tryPhase;
                int randY = ent.field_70170_p.field_73012_v.nextInt(10) - 5;
                float f1 = entityliving.field_70127_C + (entityliving.field_70125_A - entityliving.field_70127_C) * lookdist;
                float f3 = entityliving.field_70126_B + (entityliving.field_70177_z - entityliving.field_70126_B) * lookdist;
                if (noYaw) {
                    f3 = 1.0E-5f;
                }
                double d = entityliving.field_70169_q + (entityliving.field_70165_t - entityliving.field_70169_q) * (double)f;
                double d1 = entityliving.field_70167_r + (entityliving.field_70163_u - entityliving.field_70167_r) * (double)f + 1.62 - (double)entityliving.field_70129_M + (double)yOffset + (double)randY;
                double d2 = entityliving.field_70166_s + (entityliving.field_70161_v - entityliving.field_70166_s) * (double)f;
                Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
                float f4 = MathHelper.func_76134_b((float)(-f3 * 0.01745329f - 3.141593f));
                float f5 = MathHelper.func_76126_a((float)(-f3 * 0.01745329f - 3.141593f));
                float f6 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f - 0.7853982f));
                float f7 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f - 0.7853982f));
                float f8 = f5 * f6;
                float f9 = f7;
                float f10 = f4 * f6;
                double d3 = 2.0;
                Vec3 vec3d1 = vec3d.func_72441_c((double)f8 * d3, (double)f9 * d3, (double)f10 * d3);
                int lightLevel = ent.field_70170_p.func_72957_l((int)vec3d1.field_72450_a, (int)vec3d1.field_72448_b, (int)vec3d1.field_72449_c);
                if (lightLevel <= 4) continue;
                MovingObjectPosition movingobjectposition = entityliving.field_70170_p.func_72901_a(Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + 1.0), (double)ent.field_70161_v), vec3d1, true);
                foundLit = true;
                foundVec = vec3d1;
            }
            if (foundLit) {
                return foundVec;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public static MovingObjectPosition getAimBlock(EntityLivingBase ent, int yOffset, float dist, boolean noYaw) {
        try {
            EntityLivingBase entityliving = ent;
            float f = dist;
            float f1 = entityliving.field_70127_C + (entityliving.field_70125_A - entityliving.field_70127_C) * f;
            float f3 = entityliving.field_70126_B + (entityliving.field_70177_z - entityliving.field_70126_B) * f;
            if (noYaw) {
                f3 = 1.0E-5f;
            }
            double d = entityliving.field_70169_q + (entityliving.field_70165_t - entityliving.field_70169_q) * (double)f;
            double d1 = entityliving.field_70167_r + (entityliving.field_70163_u - entityliving.field_70167_r) * (double)f + 1.62 - (double)entityliving.field_70129_M + (double)yOffset;
            double d2 = entityliving.field_70166_s + (entityliving.field_70161_v - entityliving.field_70166_s) * (double)f;
            Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
            float f4 = MathHelper.func_76134_b((float)(-f3 * 0.01745329f - 3.141593f));
            float f5 = MathHelper.func_76126_a((float)(-f3 * 0.01745329f - 3.141593f));
            float f6 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f - 0.7853982f));
            float f7 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f - 0.7853982f));
            float f8 = f5 * f6;
            float f9 = f7;
            float f10 = f4 * f6;
            double d3 = 2.0;
            Vec3 vec3d1 = vec3d.func_72441_c((double)f8 * d3, (double)f9 * d3, (double)f10 * d3);
            int lightLevel = ent.field_70170_p.func_72957_l((int)vec3d1.field_72450_a, (int)vec3d1.field_72448_b, (int)vec3d1.field_72449_c);
            if (lightLevel > 4) {
                // empty if block
            }
            MovingObjectPosition movingobjectposition = entityliving.field_70170_p.func_72901_a(vec3d, vec3d1, true);
            int id = -1;
            if (movingobjectposition == null) {
                return null;
            }
            return movingobjectposition;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static EntityPlayer getClosestPlayerToEntity(World world, Entity par1Entity, double par2) {
        return ZAUtil.getClosestPlayer(world, par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v, par2);
    }

    public static EntityPlayer getClosestPlayer(World world, double par1, double par3, double par5, double par7) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            if (ZAConfigPlayerLists.whiteListUsedSenses && !ZAConfigPlayerLists.whitelistSenses.contains(CoroUtilEntity.getName((Entity)entityplayer1))) continue;
            double d5 = entityplayer1.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(d5 < par7 * par7) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static boolean canSpawnScentHere(World parWorld, Vec3 parPos) {
        if (ZAConfig.extraScentCutoffRange == -1.0) {
            return true;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)parPos.field_72450_a, (double)parPos.field_72448_b, (double)parPos.field_72449_c, (double)(parPos.field_72450_a + 1.0), (double)(parPos.field_72448_b + 1.0), (double)(parPos.field_72449_c + 1.0));
        List list = parWorld.func_72872_a(EntityScent.class, aabb = aabb.func_72314_b(ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange, ZAConfig.extraScentCutoffRange));
        return list.size() <= 0;
    }

    static {
        lastMultiply = 1.0f;
        rand = new Random();
        lastHealths = new HashMap();
        lastBleedTimes = new HashMap();
        debug = false;
    }
}

