/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.entity.render;

import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.render.ModelRendererBones;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SideOnly(value=Side.CLIENT)
public class TechneModelCoroAI
extends ModelBase
implements IModelCustom {
    public static final List<String> cubeTypes = Arrays.asList("d9e621f7-957f-4b77-b1ae-20dcd0da7751", "de81aa14-bd60-4228-8d8d-5238bcd3caaa");
    private String fileName;
    private Map<String, byte[]> zipContents = new HashMap<String, byte[]>();
    public Map<String, ModelRendererBones> parts = new LinkedHashMap<String, ModelRendererBones>();
    public Map<String, ModelRendererBones> partsAllChildren = new LinkedHashMap<String, ModelRendererBones>();
    public String textureName = null;
    public int field_78090_t = 64;
    public int field_78089_u = 32;
    private boolean textureNameSet = false;
    public boolean flattenModelTree = false;
    public float partialTickCache = 1.0f;

    public TechneModelCoroAI(String fileName, URL resource) throws ModelFormatException {
        this.fileName = fileName;
        this.loadTechneModel(resource);
    }

    private void loadTechneModel(URL fileURL) throws ModelFormatException {
        try {
            NodeList textureRes;
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(fileURL.openStream());
            while ((entry = zipInput.getNextEntry()) != null) {
                byte[] data = new byte[(int)entry.getSize()];
                int i = 0;
                while (zipInput.available() > 0 && i < data.length) {
                    data[i++] = (byte)zipInput.read();
                }
                this.zipContents.put(entry.getName(), data);
            }
            byte[] modelXml = this.zipContents.get("model.xml");
            if (modelXml == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains no model.xml file");
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(modelXml));
            NodeList nodeListTechne = document.getElementsByTagName("Techne");
            if (nodeListTechne.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Techne tag");
            }
            NodeList nodeListModel = document.getElementsByTagName("Model");
            if (nodeListModel.getLength() < 1) {
                throw new ModelFormatException("Model " + this.fileName + " contains no Model tag");
            }
            NamedNodeMap modelAttributes = nodeListModel.item(0).getAttributes();
            if (modelAttributes == null) {
                throw new ModelFormatException("Model " + this.fileName + " contains a Model tag with no attributes");
            }
            Node modelTexture = modelAttributes.getNamedItem("texture");
            if (modelTexture != null) {
                this.textureName = modelTexture.getTextContent();
            }
            if ((textureRes = document.getElementsByTagName("TextureSize")) != null) {
                String[] textureOffset = new String[2];
                Node node = textureRes.item(0);
                textureOffset = node.getTextContent().split(",");
                this.field_78090_t = Integer.parseInt(textureOffset[0]);
                this.field_78089_u = Integer.parseInt(textureOffset[1]);
            }
            NodeList shapes = null;
            if (this.flattenModelTree) {
                shapes = document.getElementsByTagName("Shape");
            } else {
                ModelRendererBones cube = new ModelRendererBones(this, "top");
                cube.textureWidth = this.field_78090_t;
                cube.textureHeight = this.field_78089_u;
                this.parts.put("top", cube);
                NodeList temp = document.getElementsByTagName("Geometry");
                Node node = temp.item(0);
                shapes = node.getChildNodes();
                this.processListRecursive(cube, shapes);
                boolean finished = false;
            }
        }
        catch (ZipException e) {
            throw new ModelFormatException("Model " + this.fileName + " is not a valid zip file");
        }
        catch (IOException e) {
            throw new ModelFormatException("Model " + this.fileName + " could not be read", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            throw new ModelFormatException("Model " + this.fileName + " contains invalid XML", (Throwable)e);
        }
    }

    public void processListRecursive(ModelRendererBones parent, NodeList nodes) {
        String childNodeName;
        Node shape;
        int i;
        for (i = 0; i < nodes.getLength(); ++i) {
            shape = nodes.item(i);
            if (!shape.getNodeName().equals("Shape")) continue;
            childNodeName = this.getNodeName(shape);
            System.out.println("creating shape: " + childNodeName);
            ModelRendererBones cube = new ModelRendererBones(this, childNodeName);
            cube.textureWidth = this.field_78090_t;
            cube.textureHeight = this.field_78089_u;
            parent.addChild(cube);
            this.processItem(cube, shape);
            cube.rotationPointXRel = cube.rotationPointX - parent.rotationPointX;
            cube.rotationPointYRel = cube.rotationPointY - parent.rotationPointY;
            cube.rotationPointZRel = cube.rotationPointZ - parent.rotationPointZ;
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            shape = nodes.item(i);
            if (!shape.getNodeName().equals("Folder")) continue;
            childNodeName = this.getNodeName(shape);
            ModelRendererBones lookupParent = this.partsAllChildren.get(childNodeName);
            if (lookupParent != null) {
                System.out.println("found folder and its shape modelrenderer: " + childNodeName);
                this.processListRecursive(lookupParent, shape.getChildNodes());
                continue;
            }
            System.out.println("TechneModelEpoch critical error: failed to find piece with name: " + childNodeName + " to link this folder to");
        }
    }

    public String getNodeName(Node shape) {
        NamedNodeMap shapeAttributes = shape.getAttributes();
        if (shapeAttributes == null) {
            throw new ModelFormatException("Shape in " + this.fileName + " has no attributes");
        }
        String childNodeName = null;
        Node name = shapeAttributes.getNamedItem("name");
        if (name == null) {
            name = shapeAttributes.getNamedItem("Name");
        }
        if (name != null) {
            childNodeName = name.getNodeValue();
        }
        if (childNodeName == null) {
            childNodeName = "Shape ???";
        }
        return childNodeName;
    }

    public void processItem(ModelRendererBones owner, Node shape) {
        NamedNodeMap shapeAttributes = shape.getAttributes();
        if (shapeAttributes == null) {
            throw new ModelFormatException("Shape in " + this.fileName + " has no attributes");
        }
        Node name = shapeAttributes.getNamedItem("name");
        String shapeName = null;
        if (name != null) {
            shapeName = name.getNodeValue();
        }
        if (shapeName == null) {
            shapeName = "Shape ";
        }
        String shapeType = null;
        Node type = shapeAttributes.getNamedItem("type");
        if (type != null) {
            shapeType = type.getNodeValue();
        }
        if (shapeType != null && !cubeTypes.contains(shapeType)) {
            FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " is not a cube, ignoring"), (Object[])new Object[0]);
            return;
        }
        try {
            boolean mirrored = false;
            String[] offset = new String[3];
            String[] position = new String[3];
            String[] rotation = new String[3];
            String[] size = new String[3];
            String[] textureOffset = new String[2];
            NodeList shapeChildren = shape.getChildNodes();
            for (int j = 0; j < shapeChildren.getLength(); ++j) {
                Node shapeChild = shapeChildren.item(j);
                String shapeChildName = shapeChild.getNodeName();
                String shapeChildValue = shapeChild.getTextContent();
                if (shapeChildValue == null) continue;
                shapeChildValue = shapeChildValue.trim();
                if (shapeChildName.equals("IsMirrored")) {
                    mirrored = !shapeChildValue.equals("False");
                    continue;
                }
                if (shapeChildName.equals("Offset")) {
                    offset = shapeChildValue.split(",");
                    continue;
                }
                if (shapeChildName.equals("Position")) {
                    position = shapeChildValue.split(",");
                    continue;
                }
                if (shapeChildName.equals("Rotation")) {
                    rotation = shapeChildValue.split(",");
                    continue;
                }
                if (shapeChildName.equals("Size")) {
                    size = shapeChildValue.split(",");
                    continue;
                }
                if (!shapeChildName.equals("TextureOffset")) continue;
                textureOffset = shapeChildValue.split(",");
            }
            owner.setTextureOffset(Integer.parseInt(textureOffset[0]), Integer.parseInt(textureOffset[1]));
            owner.mirror = mirrored;
            owner.addBox(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), Integer.parseInt(size[0]), Integer.parseInt(size[1]), Integer.parseInt(size[2]));
            float hatOffset = 23.4f;
            hatOffset = 0.0f;
            owner.setRotationPoint(Float.parseFloat(position[0]), Float.parseFloat(position[1]) - hatOffset, Float.parseFloat(position[2]));
            owner.rotateAngleX = (float)Math.toRadians(Float.parseFloat(rotation[0]));
            owner.rotateAngleY = (float)Math.toRadians(Float.parseFloat(rotation[1]));
            owner.rotateAngleZ = (float)Math.toRadians(Float.parseFloat(rotation[2]));
            owner.offsetX = Float.parseFloat(offset[0]);
            owner.offsetY = Float.parseFloat(offset[1]);
            owner.offsetZ = Float.parseFloat(offset[2]);
            if (shapeName.equals("rightarmlower")) {
                owner.inventoryRenderType = 0;
            } else if (shapeName.equals("leftarmlower")) {
                owner.inventoryRenderType = 1;
            }
            this.partsAllChildren.put(shapeName, owner);
        }
        catch (NumberFormatException e) {
            FMLLog.warning((String)("Model shape [" + shapeName + "] in " + this.fileName + " contains malformed integers within its data, ignoring"), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private void bindTexture() {
    }

    public String getType() {
        return "tcn";
    }

    public void func_78088_a(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        super.func_78088_a(par1Entity, par2, par3, par4, par5, par6, par7);
        if (par1Entity instanceof IBTAgent) {
            ((IBTAgent)par1Entity).getAIBTAgent().profile.tickAbilitiesRenderModel(this);
        }
        GL11.glPushMatrix();
        float fixScale = 0.0625f;
        GL11.glScalef((float)fixScale, (float)fixScale, (float)fixScale);
        for (ModelRendererBones part : this.parts.values()) {
            part.render((IBTAgent)par1Entity, 1.0f, this.partialTickCache);
        }
        GL11.glPopMatrix();
    }

    public void renderAll() {
    }

    public void renderPart(String partName) {
    }

    public void renderOnly(String ... groupNames) {
    }

    public void renderAllExcept(String ... excludedGroupNames) {
    }

    public void func_78086_a(EntityLivingBase par1EntityLivingBase, float par2, float par3, float par4) {
        super.func_78086_a(par1EntityLivingBase, par2, par3, par4);
        this.partialTickCache = par4;
    }
}

