/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.entity.projectile;

import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.projectile.EntityProjectileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorTrail;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityArrow
extends EntityProjectileBase {
    public int ticksInAir;
    @SideOnly(value=Side.CLIENT)
    public boolean hasDeathTicked;

    public EntityArrow(World world) {
        super(world);
    }

    public EntityArrow(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase target, double parSpeed) {
        super(par1World, par2EntityLivingBase, target, parSpeed);
    }

    public EntityArrow(World world, EntityLivingBase entityliving, double parSpeed) {
        super(world, entityliving, parSpeed);
        float speed = 0.7f;
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(-this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(-this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(-this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(-this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((-this.field_70125_A + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, 1.0f);
    }

    public EntityArrow(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            ++this.ticksInAir;
            if (this.ticksInAir > 200) {
                this.func_70106_y();
            }
        } else {
            if (this.particleBehavior == null) {
                this.particleBehavior = new ParticleBehaviorTrail(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v));
                this.particleBehavior.sourceEntity = this;
            }
            this.tickAnimate();
        }
    }

    @Override
    protected float getGravityVelocity() {
        return 0.003f;
    }

    @Override
    public MovingObjectPosition tickEntityCollision(Vec3 vec3, Vec3 vec31) {
        MovingObjectPosition movingobjectposition = null;
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(0.5, 1.0, 0.5));
        double d0 = 0.0;
        EntityLivingBase entityliving = this.getThrower();
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1 == entityliving || this.ticksInAir < 4) continue;
            entity = entity1;
            break;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        return movingobjectposition;
    }

    @Override
    protected void onImpact(MovingObjectPosition movingobjectposition) {
        try {
            if (movingobjectposition.field_72308_g != null && !this.field_70170_p.field_72995_K) {
                float damage = 5.0f;
                if (movingobjectposition.field_72308_g instanceof IBTAgent && this.getThrower() instanceof IBTAgent) {
                    if (((IBTAgent)this.getThrower()).getAIBTAgent().isEnemy(movingobjectposition.field_72308_g)) {
                        movingobjectposition.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), damage);
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_70106_y();
                        } else {
                            this.tickDeath();
                        }
                    }
                } else {
                    movingobjectposition.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), damage);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                    } else {
                        this.tickDeath();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.onImpact(movingobjectposition);
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            this.tickDeath();
        }
        super.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void tickAnimate() {
        int amount = 10 / (Minecraft.func_71410_x().field_71474_y.field_74362_aa + 1);
        double speed = 0.15;
        double speedInheritFactor = 0.5;
        for (int i = 0; i < 0; ++i) {
            double randRange = 0.5;
            EntityRotFX entityfx = this.particleBehavior.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.squareGrey, this.field_70165_t - 0.5 * randRange + this.field_70146_Z.nextDouble() * randRange, this.field_70163_u - 0.5 * randRange + this.field_70146_Z.nextDouble() * randRange, this.field_70161_v - 0.5 * randRange + this.field_70146_Z.nextDouble() * randRange, 0.0, 0.0, 0.0);
            this.particleBehavior.initParticle(entityfx);
            entityfx.callUpdatePB = false;
            ExtendedRenderer.rotEffRenderer.addEffect(entityfx);
            this.particleBehavior.particles.add(entityfx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickDeath() {
        if (!this.hasDeathTicked) {
            this.hasDeathTicked = true;
        }
    }
}

