/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.entity.block;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MovingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public boolean noCollision = false;
    public int age = 0;
    public int blockID = 0;
    public int blockMeta = 0;
    public float gravity = 0.04f;
    public float speedSlowing = 0.99f;
    public int blockifyDelay = 30;
    public float rotationYawB = 0.0f;
    public float rotationPitchB = 0.0f;
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public float rotationYawVel = 0.0f;
    public float rotationPitchVel = 0.0f;
    public int state = 0;
    public ChunkCoordinates coordsLastAir;
    public boolean blockToEntCollision = true;
    public boolean firstTick = true;
    public float scale = 1.0f;

    public MovingBlock(World var1) {
        super(var1);
        this.func_70105_a(this.scale, this.scale);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public MovingBlock(World var1, int parBlockID, int parMeta) {
        super(var1);
        this.blockID = parBlockID;
        this.blockMeta = parMeta;
        this.func_70105_a(this.scale, this.scale);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return super.func_70114_g(par1Entity);
    }

    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    public float func_70111_Y() {
        return super.func_70111_Y();
    }

    public void func_70108_f(Entity par1Entity) {
        super.func_70108_f(par1Entity);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.blockID);
        data.writeInt(this.blockMeta);
        data.writeFloat(this.gravity);
        data.writeInt(this.blockifyDelay);
    }

    public void readSpawnData(ByteBuf data) {
        this.blockID = data.readInt();
        this.blockMeta = data.readInt();
        this.gravity = data.readFloat();
        this.blockifyDelay = data.readInt();
    }

    public boolean func_70112_a(double var1) {
        return true;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)Float.valueOf(this.rotationYawB));
        this.field_70180_af.func_75682_a(3, (Object)Float.valueOf(this.rotationPitchB));
        this.field_70180_af.func_75682_a(4, (Object)Float.valueOf(this.rotationRoll));
        this.field_70180_af.func_75682_a(5, (Object)this.state);
        this.field_70180_af.func_75682_a(6, (Object)Float.valueOf(this.scale));
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && !this.noCollision;
    }

    public void func_70071_h_() {
        boolean superTick = true;
        if (superTick) {
            super.func_70071_h_();
        } else {
            this.field_70141_P = this.field_70140_Q;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70127_C = this.field_70125_A = this.rotationPitchB;
            this.field_70126_B = this.field_70177_z = this.rotationYawB;
            this.prevRotationRoll = this.rotationRoll;
        }
        ++this.age;
        if (this.field_70170_p.field_72995_K) {
            this.field_70177_z = this.rotationYawB = this.field_70180_af.func_111145_d(2);
            this.field_70125_A = this.rotationPitchB = this.field_70180_af.func_111145_d(3);
            this.rotationRoll = this.field_70180_af.func_111145_d(4);
            this.state = this.field_70180_af.func_75679_c(5);
            this.scale = this.field_70180_af.func_111145_d(6);
        } else {
            this.field_70180_af.func_75692_b(2, (Object)Float.valueOf(this.rotationYawB));
            this.field_70180_af.func_75692_b(3, (Object)Float.valueOf(this.rotationPitchB));
            this.field_70180_af.func_75692_b(4, (Object)Float.valueOf(this.rotationRoll));
            this.field_70180_af.func_75692_b(5, (Object)this.state);
            this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(this.scale));
            if (this.firstTick) {
                this.firstTick = false;
                System.out.println("commenting out PacketDispatcher.sendPacketToAllInDimension call in MovingBlock");
            }
        }
        this.field_70159_w *= (double)this.speedSlowing;
        this.field_70181_x *= (double)this.speedSlowing;
        this.field_70179_y *= (double)this.speedSlowing;
        this.field_70181_x -= (double)this.gravity;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.rotationPitchB += this.rotationPitchVel;
        this.rotationYawB += this.rotationYawVel;
        if (!this.field_70170_p.field_72995_K) {
            int aheadEndZ;
            int aheadEndY;
            int aheadEndX;
            Block id;
            if (this.field_70163_u < 0.0) {
                this.func_70106_y();
                return;
            }
            int curX = MathHelper.func_76128_c((double)this.field_70165_t);
            int curY = MathHelper.func_76128_c((double)this.field_70163_u);
            int curZ = MathHelper.func_76128_c((double)this.field_70161_v);
            Block idCurPos = this.field_70170_p.func_147439_a(curX, curY, curZ);
            if (this.blockifyDelay != -1 && this.age > this.blockifyDelay && this.isSolid(id = this.field_70170_p.func_147439_a(aheadEndX = MathHelper.func_76128_c((double)(this.field_70165_t + this.field_70159_w)), aheadEndY = MathHelper.func_76128_c((double)(this.field_70163_u + this.field_70181_x)), aheadEndZ = MathHelper.func_76128_c((double)(this.field_70161_v + this.field_70179_y))))) {
                Vec3 motion = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y);
                double aheadDistEnd = motion.func_72433_c();
                motion = motion.func_72432_b();
                for (double curDist = 0.0; curDist < aheadDistEnd; curDist += 0.5) {
                    int tryZ;
                    int tryY;
                    int tryX;
                    Block idTry;
                    int aheadZ;
                    int aheadY;
                    int aheadX = MathHelper.func_76128_c((double)(this.field_70165_t + motion.field_72450_a * curDist));
                    Block idCheck = this.field_70170_p.func_147439_a(aheadX, aheadY = MathHelper.func_76128_c((double)(this.field_70163_u + motion.field_72448_b * curDist)), aheadZ = MathHelper.func_76128_c((double)(this.field_70161_v + motion.field_72449_c * curDist)));
                    if (!this.isSolid(idCheck)) continue;
                    if (curDist < 1.0) {
                        // empty if block
                    }
                    if (!this.isSolid(idTry = this.field_70170_p.func_147439_a(tryX = MathHelper.func_76128_c((double)(this.field_70165_t + motion.field_72450_a * (curDist -= 0.5))), tryY = MathHelper.func_76128_c((double)(this.field_70163_u + motion.field_72448_b * curDist)), tryZ = MathHelper.func_76128_c((double)(this.field_70161_v + motion.field_72449_c * curDist))))) {
                        this.blockify(tryX, tryY, tryZ);
                        break;
                    }
                    this.func_70106_y();
                    break;
                }
            }
            this.tickCollisionEntities();
        }
    }

    public void tickCollisionEntities() {
        this.blockToEntCollision = true;
        if (this.blockToEntCollision) {
            double size = 0.5;
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(size, size, size));
            for (int i = 0; entities != null && i < entities.size(); ++i) {
                Entity var10 = (Entity)entities.get(i);
                if (var10 == null || var10.field_70128_L) continue;
                if (var10 instanceof EntityLivingBase) {
                    var10.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), 4.0f);
                    continue;
                }
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
                if (!(speed < 0.3)) continue;
                this.moveAway(this, var10, (float)speed * 0.5f);
            }
        }
    }

    public boolean isSolid(Block id) {
        return id.func_149688_o() != Material.field_151586_h && id.func_149688_o() != Material.field_151594_q && id.func_149688_o() != Material.field_151597_y && id.func_149688_o() != Material.field_151585_k && id.func_149688_o().func_76220_a();
    }

    public void setPositionAndRotation(double par1, double par3, double par5, float par7, float par8, float parRoll) {
        this.field_70169_q = this.field_70165_t = par1;
        this.field_70167_r = this.field_70163_u = par3;
        this.field_70166_s = this.field_70161_v = par5;
        this.field_70177_z = this.rotationYawB = par7;
        this.field_70126_B = this.rotationYawB;
        this.field_70125_A = this.rotationPitchB = par8;
        this.field_70127_C = this.rotationPitchB;
        this.prevRotationRoll = this.rotationRoll = parRoll;
        this.field_70139_V = 0.0f;
        double d3 = this.field_70126_B - par7;
        if (d3 < -180.0) {
            this.field_70126_B += 360.0f;
        }
        if (d3 >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.setRotation(par7, par8, parRoll);
    }

    protected void setRotation(float par1, float par2, float parRoll) {
        this.field_70177_z = par1 % 360.0f;
        this.field_70125_A = par2 % 360.0f;
        this.rotationRoll = parRoll % 360.0f;
    }

    public Vec3 getMoveAwayVector(Entity ent, Entity targ) {
        float vecX = (float)(ent.field_70165_t - targ.field_70165_t);
        float vecY = (float)(ent.field_70163_u - targ.field_70163_u);
        float vecZ = (float)(ent.field_70161_v - targ.field_70161_v);
        float dist2 = (float)Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        return Vec3.func_72443_a((double)(vecX / dist2), (double)(vecY / dist2), (double)(vecZ / dist2));
    }

    public void moveAway(Entity ent, Entity targ, float speed) {
        double vecX = ent.field_70165_t - targ.field_70165_t;
        double vecY = ent.field_70163_u - targ.field_70163_u;
        double vecZ = ent.field_70161_v - targ.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public void moveTowards(Entity ent, Entity targ, float speed) {
        double vecX = targ.field_70165_t - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public void triggerOwnerDied() {
        this.blockifyDelay = 1;
        this.gravity = 0.03f;
        double speed = 0.3f;
        this.field_70159_w = this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
        this.field_70181_x = (double)0.3f + this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
        this.field_70179_y = this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
    }

    public void blockify(int x, int y, int z) {
        this.field_70170_p.func_147449_b(x, y, z, Block.func_149729_e((int)this.blockID));
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        this.func_70106_y();
        return super.func_70097_a(par1DamageSource, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
    }

    protected void func_70037_a(NBTTagCompound data) {
        this.blockID = data.func_74762_e("blockID");
        this.blockMeta = data.func_74762_e("blockMeta");
        this.blockifyDelay = data.func_74762_e("blockifyDelay");
        this.gravity = data.func_74760_g("gravity");
    }

    protected void func_70014_b(NBTTagCompound data) {
        data.func_74768_a("blockID", this.blockID);
        data.func_74768_a("blockMeta", this.blockMeta);
        data.func_74768_a("blockifyDelay", this.blockifyDelay);
        data.func_74776_a("gravity", this.gravity);
    }
}

