/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt;

import CoroUtil.bt.IBTAgent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PathNavigateCustom {
    private EntityLivingBase theEntity;
    private World worldObj;
    private PathEntity currentPath;
    private double speed;
    private IAttributeInstance pathSearchRange;
    private boolean noSunPathfind;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors;
    private boolean avoidsWater;
    private boolean canSwimOnSurface;
    public boolean canSwimInWater;
    public boolean canFly;

    public PathNavigateCustom(EntityLivingBase par1EntityLiving, World par2World) {
        this.theEntity = par1EntityLiving;
        this.worldObj = par2World;
        this.pathSearchRange = par1EntityLiving.func_110148_a(SharedMonsterAttributes.field_111265_b);
    }

    public void setAvoidsWater(boolean par1) {
        this.avoidsWater = par1;
    }

    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    public void setBreakDoors(boolean par1) {
        this.canPassClosedWoodenDoors = par1;
    }

    public void setEnterDoors(boolean par1) {
        this.canPassOpenWoodenDoors = par1;
    }

    public boolean getCanBreakDoors() {
        return this.canPassClosedWoodenDoors;
    }

    public void setAvoidSun(boolean par1) {
        this.noSunPathfind = par1;
    }

    public void setSpeed(double par1) {
        this.speed = par1;
    }

    public void setCanSwim(boolean par1) {
        this.canSwimOnSurface = par1;
    }

    public float getPathSearchRange() {
        return (float)this.pathSearchRange.func_111126_e();
    }

    public PathEntity getPathToXYZ(double par1, double par3, double par5) {
        return !this.canNavigate() ? null : this.worldObj.func_72844_a((Entity)this.theEntity, MathHelper.func_76128_c((double)par1), (int)par3, MathHelper.func_76128_c((double)par5), this.getPathSearchRange(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwimOnSurface);
    }

    public boolean tryMoveToXYZ(double par1, double par3, double par5, double par7) {
        PathEntity pathentity = this.getPathToXYZ(MathHelper.func_76128_c((double)par1), (int)par3, MathHelper.func_76128_c((double)par5));
        return this.setPath(pathentity, par7);
    }

    public PathEntity getPathToEntityLiving(Entity par1Entity) {
        return !this.canNavigate() ? null : this.worldObj.func_72865_a((Entity)this.theEntity, par1Entity, this.getPathSearchRange(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwimOnSurface);
    }

    public boolean tryMoveToEntityLiving(Entity par1Entity, double par2) {
        PathEntity pathentity = this.getPathToEntityLiving(par1Entity);
        return pathentity != null ? this.setPath(pathentity, par2) : false;
    }

    public boolean setPath(PathEntity par1PathEntity, double par2) {
        if (par1PathEntity == null) {
            this.currentPath = null;
            return false;
        }
        if (!par1PathEntity.func_75876_a(this.currentPath)) {
            this.currentPath = par1PathEntity;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.func_75874_d() == 0) {
            return false;
        }
        this.speed = par2;
        Vec3 vec3 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck.field_72450_a = vec3.field_72450_a;
        this.lastPosCheck.field_72448_b = vec3.field_72448_b;
        this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (!this.noPath()) {
            Vec3 vec3;
            if (this.canNavigate()) {
                this.pathFollow();
            }
            if (!this.noPath() && (vec3 = this.currentPath.func_75878_a((Entity)this.theEntity)) != null) {
                ((IBTAgent)this.theEntity).getAIBTAgent().moveHelper.setMoveTo(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, this.speed);
            }
        }
    }

    private void pathFollow() {
        int k;
        Vec3 vec3 = this.getEntityPosition();
        int i = this.currentPath.func_75874_d();
        double adjY = 0.0;
        PathPoint pp = this.currentPath.func_75877_a(this.currentPath.func_75873_e());
        Block block = this.theEntity.field_70170_p.func_147439_a(pp.field_75839_a, pp.field_75837_b, pp.field_75838_c);
        if (block.func_149688_o() == Material.field_151586_h || block.func_149688_o() == Material.field_151587_i) {
            adjY = 1.0;
        }
        if (adjY == 0.0) {
            for (int j = this.currentPath.func_75873_e(); j < this.currentPath.func_75874_d(); ++j) {
                if (this.currentPath.func_75877_a((int)j).field_75837_b == (int)vec3.field_72448_b) continue;
                i = j;
                break;
            }
        }
        float f = this.theEntity.field_70130_N * this.theEntity.field_70130_N;
        for (k = this.currentPath.func_75873_e(); k < i; ++k) {
            if (!(vec3.func_72436_e(this.currentPath.func_75881_a((Entity)this.theEntity, k)) < (double)f)) continue;
            this.currentPath.func_75872_c(k + 1);
        }
        k = MathHelper.func_76123_f((float)this.theEntity.field_70130_N);
        int l = (int)this.theEntity.field_70131_O + 1;
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3, this.currentPath.func_75881_a((Entity)this.theEntity, j1), k, l, i1)) continue;
            this.currentPath.func_75872_c(j1);
            break;
        }
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (vec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck.field_72450_a = vec3.field_72450_a;
            this.lastPosCheck.field_72448_b = vec3.field_72448_b;
            this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.func_75879_b();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)this.getPathableYPos(), (double)this.theEntity.field_70161_v);
    }

    private int getPathableYPos() {
        if (this.theEntity.func_70090_H() && this.canSwimOnSurface) {
            int i = (int)this.theEntity.field_70121_D.field_72338_b;
            Block block = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), i, MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
            int k = 0;
            do {
                if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                    return i;
                }
                block = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), ++i, MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
            } while (++k <= 16);
            return (int)this.theEntity.field_70121_D.field_72338_b;
        }
        return (int)(this.theEntity.field_70121_D.field_72338_b + 0.5);
    }

    private boolean canNavigate() {
        return this.canFly || this.canSwimInWater || this.theEntity.field_70122_E || this.canSwimOnSurface && this.isInFluid();
    }

    private boolean isInFluid() {
        return this.theEntity.func_70090_H() || this.theEntity.func_70058_J();
    }

    private void removeSunnyPath() {
        if (!this.worldObj.func_72937_j(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), (int)(this.theEntity.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)this.theEntity.field_70161_v))) {
            for (int i = 0; i < this.currentPath.func_75874_d(); ++i) {
                PathPoint pathpoint = this.currentPath.func_75877_a(i);
                if (!this.worldObj.func_72937_j(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) continue;
                this.currentPath.func_75871_b(i - 1);
                return;
            }
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3 par1Vec3, Vec3 par2Vec3, int par3, int par4, int par5) {
        int l = MathHelper.func_76128_c((double)par1Vec3.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)par1Vec3.field_72449_c);
        double d0 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
        double d1 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3 += 2, par4, par5 += 2, par1Vec3, d0 *= d3, d1 *= d3)) {
            return false;
        }
        par3 -= 2;
        par5 -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(l * 1) - par1Vec3.field_72450_a;
        double d7 = (double)(i1 * 1) - par1Vec3.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int j1 = d0 < 0.0 ? -1 : 1;
        int k1 = d1 < 0.0 ? -1 : 1;
        int l1 = MathHelper.func_76128_c((double)par2Vec3.field_72450_a);
        int i2 = MathHelper.func_76128_c((double)par2Vec3.field_72449_c);
        int j2 = l1 - l;
        int k2 = i2 - i1;
        do {
            if (j2 * j1 <= 0 && k2 * k1 <= 0) {
                return true;
            }
            if (d6 < d7) {
                d6 += d4;
                j2 = l1 - (l += j1);
                continue;
            }
            d7 += d5;
            k2 = i2 - (i1 += k1);
        } while (this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3, par4, par5, par1Vec3, d0, d1));
        return false;
    }

    private boolean isSafeToStandAt(int par1, int par2, int par3, int par4, int par5, int par6, Vec3 par7Vec3, double par8, double par10) {
        int k1 = par1 - par4 / 2;
        int l1 = par3 - par6 / 2;
        if (!this.isPositionClear(k1, par2, l1, par4, par5, par6, par7Vec3, par8, par10)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + par4; ++i2) {
            for (int j2 = l1; j2 < l1 + par6; ++j2) {
                double d2 = (double)i2 + 0.5 - par7Vec3.field_72450_a;
                double d3 = (double)j2 + 0.5 - par7Vec3.field_72449_c;
                if (!(d2 * par8 + d3 * par10 >= 0.0)) continue;
                Block block = this.worldObj.func_147439_a(i2, par2 - 1, j2);
                Material material = block.func_149688_o();
                if (material == Material.field_151579_a) {
                    return false;
                }
                if (material == Material.field_151586_h && !this.theEntity.func_70090_H()) {
                    return false;
                }
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int par1, int par2, int par3, int par4, int par5, int par6, Vec3 par7Vec3, double par8, double par10) {
        for (int k1 = par1; k1 < par1 + par4; ++k1) {
            for (int l1 = par2; l1 < par2 + par5; ++l1) {
                for (int i2 = par3; i2 < par3 + par6; ++i2) {
                    Block block;
                    double d2 = (double)k1 + 0.5 - par7Vec3.field_72450_a;
                    double d3 = (double)i2 + 0.5 - par7Vec3.field_72449_c;
                    if (!(d2 * par8 + d3 * par10 >= 0.0) || (block = this.worldObj.func_147439_a(k1, l1, i2)).func_149655_b((IBlockAccess)this.worldObj, k1, l1, i2)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

