/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.reference;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    private Configuration configfile;
    public static int maxToolLevel;
    public static int xpRequiredToolsPercentage;
    public static int xpRequiredWeaponsPercentage;
    public static float xpPerLevelMultiplier;
    public static boolean showTooltipXP;
    public static boolean showMinimalTooltipXP;
    public static boolean detailedXpTooltip;
    public static boolean toolLeveling;
    public static int toolLevelingExtraModifiers;
    public static int[] toolModifiersAtLevels;
    public static boolean toolLevelingRandomBonuses;
    public static int[] randomBonusesAtlevels;
    public static boolean randomBonusesAreUseful;
    public static boolean randomBonusesAreRandom;
    public static boolean onlyHeadsChangeXPRequirement;
    public static Set<RandomBonuses.Modifier> deactivatedModifiers;
    public static boolean pickaxeBoostRequired;
    public static boolean mobHeadPickaxeBoost;
    public static boolean mobHeadRequiresModifier;
    public static boolean levelingPickaxeBoost;
    public static int levelingPickaxeBoostXpPercentage;
    public static float xpPerBoostLevelMultiplier;
    public static boolean changeDiamondModifier;
    public static int durabilityPercentage;
    public static int miningSpeedPercentage;
    public static boolean removeMobHeadOnPartReplacement;
    public static int partReplacementXpPenality;
    public static int partReplacementBoostXpPenality;
    public static int baseHeadDropChance;
    public static int beheadingHeadDropChance;
    public static boolean nerfVanillaTools;
    public static boolean nerfVanillaHoes;
    public static boolean nerfVanillaSwords;
    public static boolean nerfVanillaBows;
    public static boolean removeFlintDrop;
    public static boolean addFlintRecipe;
    public static int recipeGravelPerFlint;
    public static boolean disableStoneTools;
    public static boolean disableBonusMods;
    public static boolean castsBurnMaterial;
    public static boolean allowStringBinding;
    public static boolean removeObsidianAlloy;
    public static boolean easyToolRepair;
    public static boolean easyPartCrafting;
    public static boolean easyToolBuilding;
    public static boolean easyAdvancedToolBuilding;
    public static boolean allowStencilReuse;
    public static boolean allowPartReuse;
    public static boolean removeStoneTorchRecipe;
    public static boolean moreExpensiveSilkyCloth;
    public static boolean moreExpensiveSilkyJewel;
    public static boolean moreModifiersForFlux;
    public static int maxToolRepairs;
    public static boolean excludedToolsIsWhitelist;
    public static Set<String> excludedTools;
    public static Set<String> excludedModTools;
    public static boolean showDebugXP;
    public static boolean logHarvestLevelChanges;
    public static boolean logMiningLevelChanges;
    public static boolean logToolMaterialChanges;
    public static boolean logBonusExtraChance;
    public static boolean logOverrideChanges;
    private static String[] defaultExcludedTools;
    private static String[] defaultExcludedHoes;
    private static String[] defaultExcludedSwords;
    private static String[] defaultExcludedBows;
    private static String[] defaultAllowMod;

    public void init(File file) {
        this.configfile = new Configuration(file);
        this.configfile.load();
        this.sync();
    }

    public void sync() {
        String CATEGORY_Leveling = "ToolLeveling";
        String CATEGORY_Bonuses = "RandomBonuses";
        String CATEGORY_PickLeveling = "PickLeveling";
        String CATEGORY_HarvestLevels = "HarvestLevelTweaks";
        String CATEGORY_PartReplacement = "PartReplacement";
        String CATEGORY_Heads = "MobHeads";
        String CATEGORY_Tweaks = "Tweaks";
        String CATEGORY_AllowedTools = "AllowedTools";
        String CATEGORY_Debug = "Debug";
        this.configfile.setCategoryComment("ToolLeveling", "Leveling Module: Setup the leveling system how you like it");
        xpRequiredToolsPercentage = this.configfile.getInt("xpRequiredToolsPercentage", "ToolLeveling", 100, 1, 999, "Change the XP required to level up tools in % (higher = more xp needed)");
        xpRequiredWeaponsPercentage = this.configfile.getInt("xpRequiredWeaponsPercentage", "ToolLeveling", 100, 1, 999, "Change the XP required to level up weapons in % (higher = more xp needed)");
        xpPerLevelMultiplier = this.configfile.getFloat("xpPerLevelMultiplier", "ToolLeveling", 1.15f, 1.0f, 9.99f, "Exponential multiplier for required xp per level");
        onlyHeadsChangeXPRequirement = this.configfile.getBoolean("onlyHeadsChangeXPRequirement", "ToolLeveling", true, "If true, only the heads of tools are examined when determining how much XP it takes to level up. (This only matters if you manually specify that some material types level faster than others using the override module)");
        showTooltipXP = this.configfile.getBoolean("showTooltipXP", "ToolLeveling", true, "Current XP is shown when hovering over a tool");
        detailedXpTooltip = this.configfile.getBoolean("detailedXpTooltip", "ToolLeveling", true, "XP tooltip shows numbers, in addition to percentage");
        showMinimalTooltipXP = this.configfile.getBoolean("showMinimalTooltipXP", "ToolLeveling", false, "Current XP% is shown after the level");
        maxToolLevel = this.configfile.getInt("maxToolLevel", "ToolLeveling", 6, 1, 99, "");
        toolLeveling = this.configfile.getBoolean("toolLeveling", "ToolLeveling", true, "Can your skill with tools 'level up' as you use them?");
        toolLevelingExtraModifiers = this.configfile.getInt("ExtraModifiers", "ToolLeveling", 0, 0, 9, "The amount of modifiers new tools have.");
        toolModifiersAtLevels = this.configfile.get("ToolLeveling", "ModifiersAtLevels", new int[]{2, 4, 6}, "Adds an extra modifier on these levelups if 'ExtraModifiers' is enabled").getIntList();
        toolLevelingRandomBonuses = this.configfile.getBoolean("RandomBonuses", "ToolLeveling", true, "Gives a random bonus every level, if false and levelling is on modifiers are given at levels 2 and 4 (requires 'toolLeveling=true')");
        randomBonusesAtlevels = this.configfile.get("ToolLeveling", "BonusesAtLevels", new int[]{2, 3, 4, 5, 6}, "Adds a random bonus on these levelups if 'RandomBonuses' is enabled").getIntList();
        randomBonusesAreUseful = this.configfile.getBoolean("UsefulBonuses", "ToolLeveling", true, "Disables less-useful modifiers on levelups. Like a sword with silktouch, or a pickaxe with beheading.");
        randomBonusesAreRandom = this.configfile.getBoolean("CompletelyRandomBonuses", "ToolLeveling", false, "Each modifier is equally likely on levelup. Disables useful bonuses.");
        this.configfile.setCategoryComment("RandomBonuses", "Leveling Module: Allows to completely deactivate specific modifiers on levelup.");
        for (RandomBonuses.Modifier mod : RandomBonuses.Modifier.values()) {
            Property allowed = this.configfile.get("RandomBonuses", String.format("allow%s", mod.toString()), true);
            if (allowed.getBoolean()) continue;
            deactivatedModifiers.add(mod);
        }
        this.configfile.setCategoryComment("PickLeveling", "Leveling Module: Allows pickaxes to gain a mining level with enough XP. Should be used with the HarvestLevel Module.");
        pickaxeBoostRequired = this.configfile.getBoolean("pickaxeBoostRequired", "PickLeveling", true, "Every Pickaxes Mining Level is reduced by 1 and needs a mining levelup (separate from tool level) or, if enabled, a mob head modifier to advance");
        levelingPickaxeBoost = this.configfile.getBoolean("allowLevelingBoost", "PickLeveling", true, "Pickaxes gain Mining Xp by using the pickaxe.");
        mobHeadPickaxeBoost = this.configfile.getBoolean("addMobHeadBoost", "PickLeveling", true, "Mob heads can be used to boost a pickaxe's mining xp.");
        mobHeadRequiresModifier = this.configfile.getBoolean("mobHeadBoostNeedsModifier", "PickLeveling", false, "Mob head boosting requires a free modifier");
        levelingPickaxeBoostXpPercentage = this.configfile.getInt("xpRequiredPickBoostPercentage", "PickLeveling", 100, 1, 999, "Change the percentage of XP required to boost a pick (i.e. 200 means 2x normal boost xp required)");
        xpPerBoostLevelMultiplier = this.configfile.getFloat("xpPerBoostLevelMultiplier", "ToolLeveling", 1.12f, 1.0f, 9.99f, "Exponential multiplier for required boost xp per level");
        this.configfile.setCategoryComment("HarvestLevelTweaks", "Harvest Level Tweak Module: Introduces a slower mining level progression.");
        changeDiamondModifier = this.configfile.getBoolean("diamondRequired", "HarvestLevelTweaks", true, "Changes the Diamond and Emerald modifier: Apply it to a bronze level tool to obtain diamond level. Required unless you have steel or similar.");
        durabilityPercentage = this.configfile.getInt("durabilityPercentage", "HarvestLevelTweaks", 80, 1, 999, "Change durability of all tool materials (in percent)");
        miningSpeedPercentage = this.configfile.getInt("miningSpeedPercentage", "HarvestLevelTweaks", 100, 1, 999, "Change mining speed of all tool materials (in percent)");
        removeMobHeadOnPartReplacement = this.configfile.getBoolean("removeMobHead", "PartReplacement", true, "Removes the Mob Head Modifier on Tool-Head replacement, allowing it to be reapplied. Should be used with PickBoostXpPenality.");
        partReplacementXpPenality = this.configfile.getInt("XpPenality", "PartReplacement", 0, 0, 100, "How much of the current XP% shall be removed when replacing parts (So if you had 50%, and penality is 10% it'll remove 5% xp, resulting in 45%). Does not remove Skill Levels.");
        partReplacementBoostXpPenality = this.configfile.getInt("PickBoostXpPenality", "PartReplacement", 5, 0, 100, "How much of the current XP% to the next mining level shall be removed when replacing the pickaxe head. Useful to remove the mining level boost on part replacement.");
        this.configfile.setCategoryComment("MobHeads", "Mob Head Module: Adds additional Mob heads and drops");
        baseHeadDropChance = this.configfile.getInt("baseDropChange", "MobHeads", 5, 1, 100, "Base percentage for a head to drop");
        beheadingHeadDropChance = this.configfile.getInt("beheadingDropChange", "MobHeads", 2, 1, 100, "Percentage added to base percentage per level of Beheading modifier");
        this.configfile.setCategoryComment("Tweaks", "Tweak Module: Tweaks to vanilla Minecraft and Tinker's Construct");
        nerfVanillaTools = this.configfile.getBoolean("disableRegularTools", "Tweaks", true, "Makes all non-TConstruct tools mine nothing");
        nerfVanillaHoes = this.configfile.getBoolean("disableRegularHoes", "Tweaks", false, "Makes all non-TConstruct hoes to not be able to hoe ground. Use the Mattock.");
        nerfVanillaSwords = this.configfile.getBoolean("disableRegularSwords", "Tweaks", false, "Makes all non-TConstruct swords useless. Like whacking enemies with a stick.");
        nerfVanillaBows = this.configfile.getBoolean("disableRegularBows", "Tweaks", false, "Makes all non-TConstruct bows useless. You suddenly forgot how to use a bow.");
        removeFlintDrop = this.configfile.getBoolean("removeFlintDrop", "Tweaks", true, "Removes the random chance of getting flint from gravel");
        addFlintRecipe = this.configfile.getBoolean("addFlintRecipe", "Tweaks", true, "Adds a shapeless recipe to get flint from gravel");
        recipeGravelPerFlint = this.configfile.getInt("gravelPerFlint", "Tweaks", 3, 1, 9, "How many gravel are required to craft one Flint");
        removeObsidianAlloy = this.configfile.getBoolean("removeObsidianAlloy", "Tweaks", true, "Removes the creation of Obsidian in the Smeltery. This is normally used to prevent the early pre-diamond creation of obsidian tools.");
        disableStoneTools = this.configfile.getBoolean("disableStoneTools", "Tweaks", true, "Stone Tools can only be used to create casts, but no tools");
        castsBurnMaterial = this.configfile.getBoolean("castingBurnsMaterial", "Tweaks", true, "Creating a metal cast burns up the material that was used to create it");
        allowStencilReuse = this.configfile.getBoolean("allowStencilReuse", "Tweaks", false, "Allows to use stencils as blank patterns in the stencil table");
        allowPartReuse = this.configfile.getBoolean("allowPartReuse", "Tweaks", true, "Allows toolparts to be used as material in the Part Builder. Like, turn a Pick head into a Shovel head.!");
        allowStringBinding = this.configfile.getBoolean("allowStringBinding", "Tweaks", true, "Allows you to use a piece of string as a binding");
        disableBonusMods = this.configfile.getBoolean("disableBonusModifierModifiers", "Tweaks", false, "Removes the ability to add modifiers with Gold, Diamond, Netherstars etc.");
        easyToolRepair = this.configfile.getBoolean("easyToolRepair", "Tweaks", true, "Allows to repair your tool in a crafting grid, without tool station");
        easyPartCrafting = this.configfile.getBoolean("easyPartCrafting", "Tweaks", false, "Allows to craft tool parts with a pattern and the material in any crafting grid.");
        easyToolBuilding = this.configfile.getBoolean("easyToolBuilding", "Tweaks", false, "Allows to create Tool Station Tools (2-3 Parts) in any crafting grid");
        easyAdvancedToolBuilding = this.configfile.getBoolean("easyToolBuildingForge", "Tweaks", false, "Allows to also create Tool Forge Tools (4 Parts) in any crafting grid");
        removeStoneTorchRecipe = this.configfile.getBoolean("removeStoneTorchRecipe", "Tweaks", false, "Removes the recipe for Tinker's Construct's stone torch");
        moreExpensiveSilkyCloth = this.configfile.getBoolean("moreExpensiveSilkyCloth", "Tweaks", true, "Silky Cloth needs gold ingots, instead of nuggets");
        moreExpensiveSilkyJewel = this.configfile.getBoolean("moreExpensiveSilkyJewel", "Tweaks", false, "Silky Jewel needs an emerald block, instead of one emerald");
        moreModifiersForFlux = this.configfile.getBoolean("moreModifiersForFlux", "Tweaks", true, "Flux modifier requires 2 Modifiers. Because that stuff is broken.");
        maxToolRepairs = this.configfile.getInt("repairsLimit", "Tweaks", -1, -1, 999, "Limits the amount how often a tool can be repaired. -1 means unlimited repairs, like normally.");
        this.configfile.setCategoryComment("AllowedTools", "Tweak Module: This category allows you to specify which tools ARE NOT USABLE or alternatively ARE STILL USABLE if the option to disable non-TConstsruct tools is enabled.\nTo make this easier a /dumpTools command is provided, that dumps the names of all applicable items in your world. Copy'n'Paste away!");
        String type = this.configfile.getString("exclusionType", "AllowedTools", "blacklist", "Change the type of the exclusion.\n'blacklist' means the listed tools are made unusable.\n'whitelist' means ALL tools except the listed ones are unusable.", new String[]{"whitelist", "blacklist"});
        excludedToolsIsWhitelist = "whitelist".equals(type);
        String[] tools = this.configfile.getStringList("tools", "AllowedTools", defaultExcludedTools, "Tools that are excluded if the option to nerf non-tinkers tools is enabled.");
        String[] swords = this.configfile.getStringList("swords", "AllowedTools", defaultExcludedSwords, "Swords that are excluded if the option to nerf non-tinkers swords is enabled.");
        String[] bows = this.configfile.getStringList("bows", "AllowedTools", defaultExcludedBows, "Bows that are excluded if the option to nerf non-tinkers bows is enabled.");
        String[] hoes = this.configfile.getStringList("hoes", "AllowedTools", defaultExcludedHoes, "Hoes that are excluded if the option to nerf non-tinkers hoes is enabled.");
        excludedModTools.addAll(Arrays.asList(this.configfile.getStringList("mods", "AllowedTools", defaultAllowMod, "Here you can exclude entire mods by adding their mod-id (the first part of the string).")));
        if (nerfVanillaTools) {
            excludedTools.addAll(Arrays.asList(tools));
        }
        if (nerfVanillaSwords) {
            excludedTools.addAll(Arrays.asList(swords));
        }
        if (nerfVanillaBows) {
            excludedTools.addAll(Arrays.asList(bows));
        }
        if (nerfVanillaHoes) {
            excludedTools.addAll(Arrays.asList(hoes));
        }
        this.configfile.setCategoryComment("Debug", "Stuff to give you/me more information");
        showDebugXP = this.configfile.getBoolean("showDebugXP", "Debug", false, "Current Tool/Pick XP is shown as debug (F3) text");
        logHarvestLevelChanges = this.configfile.getBoolean("logBlockHarvestLevelChange", "Debug", true, "Logs when the harvest level of a block is changed");
        logMiningLevelChanges = this.configfile.getBoolean("logToolMiningLevelChange", "Debug", true, "Logs when the mining level of a (non-tinker) tool is changed");
        logToolMaterialChanges = this.configfile.getBoolean("logTinkerMaterialChange", "Debug", true, "Logs when the mining level of a tinkers tool material is changed");
        logBonusExtraChance = this.configfile.getBoolean("logBonusExtraChance", "Debug", true, "Logs how much the extra-chance from doing stuff you had when getting a random bonus on levelup.");
        logOverrideChanges = this.configfile.getBoolean("logExcessiveOverrideChanges", "Debug", false, "Logs every single thing done by the Override module. Use at your own risk. ;)");
        this.configfile.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("IguanaTweaksTConstruct")) {
            this.sync();
        }
    }

    static {
        deactivatedModifiers = new HashSet<RandomBonuses.Modifier>();
        excludedTools = new HashSet<String>();
        excludedModTools = new HashSet<String>();
        defaultExcludedTools = new String[]{"Botania:manasteelAxe", "Botania:manasteelPick", "Botania:manasteelShovel", "Steamcraft:axeGildedGold", "Steamcraft:pickGildedGold", "Steamcraft:shovelGildedGold", "Steamcraft:axeBrass", "Steamcraft:pickBrass", "Steamcraft:shovelBrass", "IC2:itemToolBronzeAxe", "IC2:itemToolBronzePickaxe", "IC2:itemToolBronzeSpade", "Railcraft:tool.steel.axe", "Railcraft:tool.steel.pickaxe", "Railcraft:tool.steel.shovel"};
        defaultExcludedHoes = new String[]{"Steamcraft:hoeGildedGold", "Steamcraft:hoeBrass", "IC2:itemToolBronzeHoe", "Railcraft:tool.steel.hoe"};
        defaultExcludedSwords = new String[]{"Botania:manasteelSword", "Steamcraft:swordGildedGold", "Steamcraft:swordBrass", "ThermalExpansion:tool.battleWrenchInvar", "IC2:itemToolBronzeSword", "Railcraft:tool.steel.sword"};
        defaultExcludedBows = new String[0];
        defaultAllowMod = new String[]{"minecraft", "Metallurgy", "Natura", "BiomesOPlenty", "ProjRed|Exploration", "appliedenergistics2", "MekanismTool", "ThermalFoundation"};
    }
}

