/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools.baseclasses;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.RFItemBase;
import com.brandon3055.draconicevolution.common.network.ToolModePacket;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.input.Keyboard;

public class ToolBase
extends RFItemBase {
    private static final Set SHOVEL_OVERRIDES = Sets.newHashSet((Object[])new Object[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});
    private static final Set PICKAXE_OVERRIDES = Sets.newHashSet((Object[])new Object[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x});
    private static final Set AXE_OVERRIDES = Sets.newHashSet((Object[])new Object[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Material.field_151575_d, Material.field_151584_j, Material.field_151589_v, Material.field_151570_A, Material.field_151585_k, Material.field_151582_l});
    private Set blockOverrides;
    protected float efficiencyOnProperMaterial = 4.0f;
    public float damageVsEntity;
    protected Item.ToolMaterial toolMaterial;
    public int energyPerOperation = 0;

    protected ToolBase(float baseDamage, Item.ToolMaterial material, Set blockOverrides) {
        this.toolMaterial = material;
        this.blockOverrides = blockOverrides == null ? new HashSet() : blockOverrides;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.efficiencyOnProperMaterial = material.func_77998_b();
        this.damageVsEntity = baseDamage + material.func_78000_c();
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (toolClass.equals("pickaxe")) {
            this.blockOverrides.addAll(PICKAXE_OVERRIDES);
        }
        if (toolClass.equals("shovel")) {
            this.blockOverrides.addAll(SHOVEL_OVERRIDES);
        }
        if (toolClass.equals("axe")) {
            this.blockOverrides.addAll(AXE_OVERRIDES);
        }
        super.setHarvestLevel(toolClass, level);
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return this.blockOverrides.contains(block) || this.blockOverrides.contains(block.func_149688_o()) ? this.efficiencyOnProperMaterial : 1.0f;
    }

    public boolean func_150897_b(Block block) {
        if (this.getToolClasses(null).contains("pickaxe")) {
            return true;
        }
        return this.blockOverrides.contains(block);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        float speed = ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) ? this.efficiencyOnProperMaterial : super.getDigSpeed(stack, block, meta);
        if (this.getEnergyStored(stack) >= this.energyPerOperation) {
            float f = ItemNBTHelper.getFloat((ItemStack)stack, (String)"ToolDigMultiplier", (float)1.0f);
            if (speed > 50.0f) {
                f *= f;
            }
            return f * speed;
        }
        return 0.5f;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        if (!this.getToolClasses(stack).isEmpty()) {
            list.add(new ItemConfigField(4, slot, "ToolDigMultiplier").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.01f)).readFromItem(stack, Float.valueOf(1.0f)));
        }
        if (!this.getToolClasses(stack).isEmpty()) {
            list.add(new ItemConfigField(6, slot, "BaseSafeAOE").readFromItem(stack, false));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        boolean show = InfoHelper.holdShiftForDetails((List)list);
        if (show) {
            List<ItemConfigField> l = this.getFields(stack, 0);
            for (ItemConfigField f : l) {
                list.add(f.getTooltipInfo());
            }
            if (this.getCapacity(stack) > 0) {
                list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getEnergyStored(stack)) + " / " + Utills.formatNumber((long)this.getCapacity(stack)));
            }
        }
        this.addAditionalInformation(stack, player, list, extended);
        if (show && !ConfigHandler.disableLore) {
            InfoHelper.addLore((ItemStack)stack, (List)list, (boolean)true);
        }
        InfoHelper.addEnergyInfo((ItemStack)stack, (List)list);
    }

    @SideOnly(value=Side.CLIENT)
    public void addAditionalInformation(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        list.add(StatCollector.func_74838_a((String)"info.de.press.txt") + " " + Keyboard.getKeyName((int)KeyBindings.toolConfig.func_151463_i()) + " " + StatCollector.func_74838_a((String)"info.de.toOpenConfigGUI.txt"));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77977_a().contains(":wyvern")) {
            return EnumRarity.rare;
        }
        if (stack.func_77977_a().contains(":draconic")) {
            return EnumRarity.epic;
        }
        return EnumRarity.uncommon;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && !BrandonsCore.proxy.isDedicatedServer()) {
            ToolBase.handleModeChange(stack, player, InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown());
        } else if (world.field_72995_K && BrandonsCore.proxy.getMCServer() == null) {
            ToolBase.handleModeChange(stack, player, InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown());
            DraconicEvolution.network.sendToServer((IMessage)new ToolModePacket(InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown()));
        }
        return super.func_77659_a(stack, world, player);
    }

    public static void handleModeChange(ItemStack stack, EntityPlayer player, boolean shift, boolean ctrl) {
        block8: {
            RFItemBase item;
            block9: {
                block7: {
                    if (stack == null || !(stack.func_77973_b() instanceof RFItemBase)) {
                        return;
                    }
                    item = (RFItemBase)stack.func_77973_b();
                    if (!shift || ctrl) break block7;
                    List<ItemConfigField> fields = item.getFields(stack, player.field_71071_by.field_70461_c);
                    for (ItemConfigField field : fields) {
                        if (!field.name.equals("ToolDigAOE")) continue;
                        int aoe = (Integer)field.value;
                        if (++aoe > (Integer)field.max) {
                            aoe = (Integer)field.min;
                        }
                        field.value = aoe;
                        DataUtills.writeObjectToItem((ItemStack)stack, (Object)field.value, (int)field.datatype, (String)field.name);
                    }
                    break block8;
                }
                if (!ctrl || shift) break block9;
                List<ItemConfigField> fields = item.getFields(stack, player.field_71071_by.field_70461_c);
                for (ItemConfigField field : fields) {
                    if (!field.name.equals("ToolDigDepth")) continue;
                    int aoe = (Integer)field.value;
                    if (++aoe > (Integer)field.max) {
                        aoe = (Integer)field.min;
                    }
                    field.value = aoe;
                    DataUtills.writeObjectToItem((ItemStack)stack, (Object)field.value, (int)field.datatype, (String)field.name);
                }
                break block8;
            }
            if (!ctrl || !shift) break block8;
            List<ItemConfigField> fields = item.getFields(stack, player.field_71071_by.field_70461_c);
            for (ItemConfigField field : fields) {
                if (!field.name.equals("WeaponAttackAOE")) continue;
                int aoe = (Integer)field.value;
                if (++aoe > (Integer)field.max) {
                    aoe = (Integer)field.min;
                }
                field.value = aoe;
                DataUtills.writeObjectToItem((ItemStack)stack, (Object)field.value, (int)field.datatype, (String)field.name);
            }
        }
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }
}

