/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools.baseclasses;

import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolBase;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public abstract class MiningTool
extends ToolBase {
    public MiningTool(Item.ToolMaterial material) {
        super(0.0f, material, null);
    }

    public Map<Block, Integer> getObliterationList(ItemStack stack) {
        HashMap<Block, Integer> blockMap = new HashMap<Block, Integer>();
        NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)stack);
        if (compound.func_82582_d()) {
            return blockMap;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack1;
            NBTTagCompound tag = new NBTTagCompound();
            if (compound.func_74764_b("Item" + i)) {
                tag = compound.func_74775_l("Item" + i);
            }
            if (tag.func_82582_d() || (stack1 = ItemStack.func_77949_a((NBTTagCompound)tag)) == null || !(stack1.func_77973_b() instanceof ItemBlock)) continue;
            blockMap.put(Block.func_149634_a((Item)stack1.func_77973_b()), stack1.func_77960_j());
        }
        return blockMap;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        int radius = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ToolDigAOE", (int)0);
        int depth = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ToolDigDepth", (int)1) - 1;
        return this.getEnergyStored(stack) >= this.energyPerOperation && radius > 0 ? this.breakAOEBlocks(stack, x, y, z, radius, depth, player) : super.onBlockStartBreak(stack, x, y, z, player);
    }

    public boolean func_150894_a(ItemStack stack, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        if (ItemNBTHelper.getInteger((ItemStack)stack, (String)"ToolDigAOE", (int)0) == 0) {
            this.extractEnergy(stack, 80, false);
        }
        return super.func_150894_a(stack, p_150894_2_, p_150894_3_, p_150894_4_, p_150894_5_, p_150894_6_, p_150894_7_);
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ToolHandler.updateGhostBlocks(player, world);
        return super.func_77659_a(stack, world, player);
    }

    public boolean breakAOEBlocks(ItemStack stack, int x, int y, int z, int breakRadius, int breakDepth, EntityPlayer player) {
        int zPos;
        int yPos;
        int xPos;
        HashMap<Block, Integer> blockMap = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"ToolVoidJunk", (boolean)false) ? this.getObliterationList(stack) : new HashMap();
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        boolean effective = false;
        if (block != null) {
            for (String s : this.getToolClasses(stack)) {
                if (!block.isToolEffective(s, meta) && !(this.func_150893_a(stack, block) > 1.0f)) continue;
                effective = true;
            }
        }
        if (!effective) {
            return true;
        }
        float refStrength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)player.field_70170_p, (int)x, (int)y, (int)z);
        MovingObjectPosition mop = ToolHandler.raytraceFromEntity(player.field_70170_p, (Entity)player, 4.5);
        if (mop == null) {
            ToolHandler.updateGhostBlocks(player, player.field_70170_p);
            return true;
        }
        int sideHit = mop.field_72310_e;
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"BaseSafeAOE", (boolean)false)) {
            for (xPos = x - xMin; xPos <= x + xMax; ++xPos) {
                for (yPos = y + yOffset - yMin; yPos <= y + yOffset + yMax; ++yPos) {
                    for (zPos = z - zMin; zPos <= z + zMax; ++zPos) {
                        if (player.field_70170_p.func_147438_o(xPos, yPos, zPos) == null) continue;
                        if (player.field_70170_p.field_72995_K) {
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.baseSafeAOW.txt", new Object[0]));
                        } else {
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, ((EntityPlayerMP)player).field_70170_p));
                        }
                        return true;
                    }
                }
            }
        }
        for (xPos = x - xMin; xPos <= x + xMax; ++xPos) {
            for (yPos = y + yOffset - yMin; yPos <= y + yOffset + yMax; ++yPos) {
                for (zPos = z - zMin; zPos <= z + zMax; ++zPos) {
                    this.breakExtraBlock(stack, player.field_70170_p, xPos, yPos, zPos, breakRadius * (breakDepth / 2 + 1), player, refStrength, Math.abs(x - xPos) <= 1 && Math.abs(y - yPos) <= 1 && Math.abs(z - zPos) <= 1, blockMap);
                }
            }
        }
        List items = player.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - xMin), (double)(y + yOffset - yMin), (double)(z - zMin), (double)(x + xMax + 1), (double)(y + yOffset + yMax + 1), (double)(z + zMax + 1)));
        for (EntityItem item : items) {
            if (player.field_70170_p.field_72995_K) continue;
            item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)item));
            item.field_145804_b = 0;
            if (!ConfigHandler.rapidlyDespawnMinedItems) continue;
            item.lifespan = 100;
        }
        return true;
    }

    protected void breakExtraBlock(ItemStack stack, World world, int x, int y, int z, int totalSize, EntityPlayer player, float refStrength, boolean breakSound, Map<Block, Integer> blockMap) {
        BlockEvent.BreakEvent event;
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block.func_149688_o() instanceof MaterialLiquid || block.func_149712_f(world, x, y, x) == -1.0f && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        boolean effective = false;
        for (String s : this.getToolClasses(stack)) {
            if (!block.isToolEffective(s, meta) && !(this.func_150893_a(stack, block) > 1.0f)) continue;
            effective = true;
        }
        if (!effective) {
            return;
        }
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!world.field_72995_K && (event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)player), (int)x, (int)y, (int)z)).isCanceled()) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            return;
        }
        if (!player.func_146099_a(block) || !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int scaledPower = this.energyPerOperation + totalSize * (this.energyPerOperation / 10);
        if (player.field_71075_bZ.field_75098_d || blockMap.containsKey(block) && blockMap.get(block) == meta) {
            block.func_149681_a(world, x, y, z, meta, player);
            if (block.removedByPlayer(world, player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            if (blockMap.containsKey(block) && blockMap.get(block) == meta) {
                this.extractEnergy(stack, scaledPower, false);
            }
            if (breakSound) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            }
            return;
        }
        this.extractEnergy(stack, scaledPower, false);
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, player);
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, player, x, y, z, meta);
                player.func_71020_j(-0.025f);
                if (block.getExpDrop((IBlockAccess)world, meta, EnchantmentHelper.func_77517_e((EntityLivingBase)player)) > 0) {
                    player.func_71023_q(block.getExpDrop((IBlockAccess)world, meta, EnchantmentHelper.func_77517_e((EntityLivingBase)player)));
                }
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
            mpPlayer.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            if (breakSound) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            }
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
    }
}

