/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes.modules;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.aobd.AOBD;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.OreGas;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class Mekanism
extends RecipesModule {
    private static List<OreGas> gasList = new ArrayList<OreGas>();

    public Mekanism() {
        super(CompatType.MEKANISM, "iron", "gold", "silver", "lead", "osmium", "copper", "tin");
    }

    @Override
    protected void preInit() {
        for (String gas : AOBD.userDefinedGases.split(",")) {
            String name = gas.trim();
            OreGasAOBD clean = new OreGasAOBD(name, "clean" + name, "oregas." + name.toLowerCase());
            OreGas slurry = new OreGasAOBD(name, name, "oregas." + name.toLowerCase()).setCleanGas(clean);
            gasList.add(slurry);
        }
    }

    @Override
    public void initOre(Ore ore) {
        String name = ore.name();
        OreGasAOBD clean = new OreGasAOBD(ore, "clean" + name, "oregas." + name.toLowerCase());
        OreGas slurry = new OreGasAOBD(ore, name, "oregas." + name.toLowerCase()).setCleanGas(clean);
        gasList.add(slurry);
        for (Object stack : OreDictionary.getOres((String)("ore" + name))) {
            Mekanism.addEnrichmentChamberRecipe((ItemStack)stack, Mekanism.getOreStack("dust", ore, 2));
        }
        Mekanism.addEnrichmentChamberRecipe(Mekanism.getOreStack("dustDirty", ore), Mekanism.getOreStack("dust", ore));
        Mekanism.addCrusherRecipe(Mekanism.getOreStack("clump", ore), Mekanism.getOreStack("dustDirty", ore));
        Gas oxygen = GasRegistry.getGas((String)"oxygen");
        for (ItemStack stack : OreDictionary.getOres((String)("ore" + name))) {
            Mekanism.addPurificationChamberRecipe(stack, oxygen, Mekanism.getOreStack("clump", ore, 3));
        }
        Mekanism.addPurificationChamberRecipe(Mekanism.getOreStack("shard", ore), oxygen, Mekanism.getOreStack("clump", ore));
        Gas hydrogenChloride = GasRegistry.getGas((String)"hydrogenChloride");
        for (ItemStack stack : OreDictionary.getOres((String)("ore" + name))) {
            Mekanism.addChemicalInjectionChamberRecipe(stack, hydrogenChloride, Mekanism.getOreStack("shard", ore, 4));
        }
        Mekanism.addChemicalInjectionChamberRecipe(Mekanism.getOreStack("crystal", ore), hydrogenChloride, Mekanism.getOreStack("shard", ore));
        for (ItemStack stack : OreDictionary.getOres((String)("ore" + name))) {
            Mekanism.addChemicalDissolutionChamberRecipe(stack, new GasStack((Gas)slurry, 1000));
        }
        Mekanism.addChemicalWasherRecipe(new GasStack((Gas)slurry, 1), new GasStack((Gas)slurry.getCleanGas(), 1));
        Mekanism.addChemicalCrystallizerRecipe(new GasStack((Gas)slurry.getCleanGas(), 200), Mekanism.getOreStack("crystal", ore));
    }

    private static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        Mekanism.addRecipe("EnrichmentChamberRecipe", input, output);
    }

    private static void addCrusherRecipe(ItemStack input, ItemStack output) {
        Mekanism.addRecipe("CrusherRecipe", input, output);
    }

    private static void addPurificationChamberRecipe(ItemStack input, Gas gas, ItemStack output) {
        Mekanism.addRecipe("PurificationChamberRecipe", input, gas, output);
    }

    private static void addChemicalInjectionChamberRecipe(ItemStack input, Gas gas, ItemStack output) {
        Mekanism.addRecipe("ChemicalInjectionChamberRecipe", input, gas, output);
    }

    private static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        Mekanism.addRecipe("ChemicalDissolutionChamberRecipe", input, output);
    }

    private static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        Mekanism.addRecipe("ChemicalWasherRecipe", input, output);
    }

    private static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        Mekanism.addRecipe("ChemicalCrystallizerRecipe", input, output);
    }

    private static void addRecipe(String key, ItemStack input, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"Mekanism", (String)key, (NBTTagCompound)nbt);
    }

    private static void addRecipe(String key, ItemStack input, Gas gas, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("gasType", (NBTBase)gas.write(new NBTTagCompound()));
        nbt.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"Mekanism", (String)key, (NBTTagCompound)nbt);
    }

    private static void addRecipe(String key, ItemStack input, GasStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("output", (NBTBase)output.write(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"Mekanism", (String)key, (NBTTagCompound)nbt);
    }

    private static void addRecipe(String key, GasStack input, GasStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)input.write(new NBTTagCompound()));
        nbt.func_74782_a("output", (NBTBase)output.write(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"Mekanism", (String)key, (NBTTagCompound)nbt);
    }

    private static void addRecipe(String key, GasStack input, ItemStack output) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("input", (NBTBase)input.write(new NBTTagCompound()));
        nbt.func_74782_a("output", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"Mekanism", (String)key, (NBTTagCompound)nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(TextureMap map) {
        IIcon clean = map.func_94245_a("mekanism:LiquidCleanOre");
        IIcon dirty = map.func_94245_a("mekanism:LiquidOre");
        for (OreGas gas : gasList) {
            gas.setIcon(dirty);
            gas.getCleanGas().setIcon(clean);
        }
    }

    private static class OreGasAOBD
    extends OreGas {
        private final Ore ore;
        private final String name;

        public OreGasAOBD(Ore ore, String s, String name) {
            super(s, name);
            this.name = null;
            this.ore = ore;
            GasRegistry.register((Gas)this);
        }

        public OreGasAOBD(String ore, String s, String name) {
            super(s, name);
            this.ore = null;
            this.name = ore;
            GasRegistry.register((Gas)this);
        }

        public String getLocalizedName() {
            String fullName = "gas.aobd." + (this.isClean() ? "clean" : "dirty") + (this.ore != null ? this.ore.name() : this.name) + ".name";
            String shortName = "gas.aobd." + (this.isClean() ? "clean" : "dirty") + ".name";
            return StatCollector.func_94522_b((String)fullName) ? StatCollector.func_74838_a((String)fullName) : String.format(StatCollector.func_74838_a((String)shortName), this.name != null ? this.name : this.ore.translatedName());
        }

        public String getOreName() {
            return String.format(StatCollector.func_74838_a((String)"gas.aobd.ore.name"), this.name != null ? this.name : this.ore.translatedName());
        }
    }
}

