/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.ore;

import ganymedes01.aobd.lib.CompatType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.StatCollector;

public class Ore {
    public static final ArrayList<Ore> ores = new ArrayList();
    private static final Map<String, String> defaultOres = new HashMap<String, String>();
    private final String name;
    private String extra;
    private double energy;
    private final Set<CompatType> enabledTypes = new HashSet<CompatType>();
    private boolean disabled = false;
    private Color colour = Color.WHITE;

    public static Ore newOre(String name) {
        double e = name.equals("Cobalt") || name.equals("Ardite") || name.equals("FzDarkIron") ? 3.0 : (name.equals("Osmium") || name.equals("Tungsten") ? 2.0 : 1.0);
        String extra = defaultOres.get(name);
        if (extra == null) {
            extra = name;
        }
        return new Ore(name, extra, e);
    }

    public static Ore newNetherOre(String name) {
        Ore ore = Ore.newOre(name);
        ore.energy *= 2.0;
        return ore;
    }

    protected Ore(String name, String extra, double energy) {
        this.name = name;
        this.extra = extra;
        this.energy = energy;
        ores.add(this);
        this.enabledTypes.addAll(Arrays.asList(CompatType.values()));
    }

    public String name() {
        return this.name;
    }

    public String translatedName() {
        String unloc = "metal.aobd." + this.name().toLowerCase() + ".name";
        return StatCollector.func_94522_b((String)unloc) ? StatCollector.func_74838_a((String)unloc) : this.name();
    }

    public String extra() {
        return this.extra;
    }

    public double energy(double e) {
        return e * this.energy;
    }

    public void setEnergy(double e) {
        this.energy = e;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public boolean isCompatEnabled(CompatType type) {
        return this.isEnabled() && this.enabledTypes.contains((Object)type);
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void configType(boolean enable, CompatType type) {
        if (enable) {
            this.enabledTypes.add(type);
        } else {
            this.enabledTypes.remove((Object)type);
        }
    }

    public void setDisabled(boolean flag) {
        this.disabled = flag;
    }

    public int colour() {
        return this.colour.getRGB() & 0xFFFFFF;
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        if (colour != null) {
            this.colour = colour;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Ore && this.name.equals(((Ore)obj).name);
    }

    public String toString() {
        return this.name();
    }

    static {
        defaultOres.put("Cobalt", "Iron");
        defaultOres.put("Ardite", "Gold");
        defaultOres.put("Aluminium", "Tin");
        defaultOres.put("Copper", "Gold");
        defaultOres.put("Tin", "Iron");
        defaultOres.put("Lead", "Silver");
        defaultOres.put("Iron", "Nickel");
        defaultOres.put("Silver", "Lead");
        defaultOres.put("Nickel", "Platinum");
        defaultOres.put("FzDarkIron", "Silver");
    }
}

