/*
 * Decompiled with CFR 0.152.
 */
package neresources.entries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import neresources.api.messages.RegisterDungeonMessage;
import neresources.utils.ReflectionHelper;
import neresources.utils.WeightedRandomChestContentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class DungeonEntry {
    private Map<ItemStack, Float> chestDrops = new LinkedHashMap<ItemStack, Float>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public DungeonEntry(String name, ChestGenHooks chestGenHooks) {
        int totalWeight = 0;
        ArrayList content = (ArrayList)ReflectionHelper.getObject(ChestGenHooks.class, "contents", chestGenHooks);
        for (WeightedRandomChestContent chestItem : content) {
            totalWeight += chestItem.field_76292_a;
        }
        for (WeightedRandomChestContent chestItem : WeightedRandomChestContentHelper.sort(content.toArray(new WeightedRandomChestContent[content.size()]))) {
            this.chestDrops.put(chestItem.field_76297_b, Float.valueOf((float)(chestItem.field_76296_e + chestItem.field_76295_d) / 2.0f * (float)chestItem.field_76292_a / (float)totalWeight));
        }
        this.name = name;
        this.minStacks = chestGenHooks.getMin();
        this.maxStacks = chestGenHooks.getMax();
    }

    public DungeonEntry(RegisterDungeonMessage message) {
        this.chestDrops = message.getChestDrops();
        this.name = message.getName();
        this.maxStacks = message.getMaxStacks();
        this.minStacks = message.getMinStacks();
    }

    public boolean containsItem(ItemStack itemStack) {
        for (ItemStack item : this.chestDrops.keySet()) {
            if (!item.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Map<ItemStack, Float> getChestDrops() {
        return this.chestDrops;
    }

    public ItemStack[] getItemStacks() {
        return this.chestDrops.keySet().toArray(new ItemStack[this.chestDrops.size()]);
    }

    public Float[] getChances() {
        return this.chestDrops.values().toArray(new Float[this.chestDrops.size()]);
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }
}

